<?php namespace NetSTI\Backend;

use Event;
use Backend;
use System\Classes\PluginBase;
use Backend\Classes\Controller as BackendController;

/**
 * Backend Plugin Information File
 */
class Plugin extends PluginBase{

	/**
	 * Returns information about this plugin.
	 *
	 * @return array
	 */
	public function pluginDetails()
	{
		return [
			'name'        => 'Backend',
			'description' => 'Flat Backend Theme',
			'author'      => 'NetSTI',
			'icon'        => 'icon-rocket'
		];
	}

	public function boot()
	{
		Event::listen('backend.menu.extendItems', function($manager) {

			$manager->addMainMenuItems('October.Backend', [
				'dashboard' => [
					'icon'        => 'icon-rocket',
				]
			]);
		});

		BackendController::extend(function($controller){
			$controller->addCss('/plugins/netsti/backend/assets/css/font.css');
			$controller->addCss('/plugins/netsti/backend/assets/css/theme.css');
		});
	}

}
