<?php namespace NetSTI\Hotel;

use DB;
use Event;
use System\Classes\PluginBase;

class Plugin extends PluginBase{

	public $individual;

    public function registerSettings(){
		return [
			'hotel' => [
				'label'       => 'netsti.hotel::lang.hotel_settings',
				'description' => 'netsti.hotel::lang.hotel_settings_description',
				'icon'        => 'icon-bed',
				'class'       => 'NetSTI\Hotel\Models\Settings',
				'category'    => 'netsti.hotel::lang.manage',
				'order'       => 105,
				'keywords'    => 'hotel'
			]
		];
	}

	// COMPONENTS
	public function registerComponents(){
		return [
			'NetSTI\Hotel\Components\RoomTypes' => 'roomsTypeComponent',
			'NetSTI\Hotel\Components\Booking' => 'bookingForm',
		];
	}

	// MARKUP TAGS
	public function registerMarkupTags(){
		return [
			'functions' => [
				'_' => ['Lang', 'get']
			]
		];
	}

	public function boot(){
		$ind = false;

        Event::listen('backend.menu.extendItems', function($manager) {
            $manager->addSideMenuItems('NetSTI.Hotel', 'hotel', [
                'booking' => [
                    'counter' => ($i = DB::table('netsti_hotel_bookings')->where('status', '>', 0)->count()) ? $i : null
                ]
            ]);
        });

        Event::listen('backend.form.extendFields', function($widget) {
			if (!$widget->model instanceof \NetSTI\Connections\Models\MailSettings){
				$this->ind = true;
				return;
			}else{
				$widget->addSecondaryTabFields([
					"booking" => [
						"label" => "netsti.hotel::lang.mail.book_reply",
						"span" => "full",
						"size" => "large",
						"type" => "richeditor",
						"tab" => "netsti.hotel::lang.menu.booking"
					],
				]);
			}
		});

		Event::listen('backend.form.extendFields', function($widget) {
			if($this->ind){
				if (!$widget->model instanceof \NetSTI\System\Models\CompanySettings){
					return;
				}else{
					$widget->addTabFields([
						"reply" => [
							"label" => "netsti.hotel::lang.mail.book_reply",
							"span" => "full",
							"size" => "large",
							"type" => "richeditor",
							"tab" => "netsti.hotel::lang.fields.email",
						],
					]);
				}
			}
		});
    }
}
