<?php namespace NetSTI\Hotel\Components;

use Mail;
use Lang;
use Flash;
use Carbon;
use Backend;
use Validator;
use ValidationException;
use NetSTI\System\Models\CompanySettings;
use NetSTI\Hotel\Models\Booking as BookingModel;

class Booking extends \Cms\Classes\ComponentBase{

	public $inputClass;
	public $groupClass;
	public $ifLabel;
	public $ifInline;
	public $icons;
	public $submitClass;
	public $ifPhone;
	public $ifCheckout;
	public $ifPeople;


	public function defineProperties(){
		return [
			'inputClass' => [
				'title'        => 'Input Class',
				'type'         => 'string',
				'default'      => 'form-control',
				'group'			=> 'Form Options',
				'showExternalParam' => false,
			],
			'groupClass' => [
				'title'        => 'Input Group Class',
				'type'         => 'string',
				'default'      => 'form-group',
				'group'			=> 'Form Options',
				'showExternalParam' => false,
			],
			'ifLabel' => [
				'title'		=> 'Show Labels',
				'type'		=> 'checkbox',
				'group'			=> 'Form Options',
				'showExternalParam' => false,
				'default'	=> true
			],
			'ifInline' => [
				'title'		=> 'Inline Form',
				'type'		=> 'checkbox',
				'group'			=> 'Form Options',
				'showExternalParam' => false,
				'default'	=> true
			],
			'icons' => [
				'title'		=> 'With Icons',
				'type'		=> 'checkbox',
				'showExternalParam' => false,
				'group'			=> 'Form Options',
				'default'	=> false,
			],
			'submitClass' => [
				'title'        => 'Submit Class',
				'type'         => 'string',
				'default'      => 'btn btn-primary',
				'group'			=> 'Form Options',
				'showExternalParam' => false,
			],
			'ifPhone' => [
				'title'		=> 'Show Phone',
				'type'		=> 'checkbox',
				'group'		=> 'Extra Fields',
				'showExternalParam' => false,
				'default'	=> false
			],
			'ifCheckout' => [
				'title'		=> 'Show Checkout',
				'type'		=> 'checkbox',
				'group'		=> 'Extra Fields',
				'showExternalParam' => false,
				'default'	=> true
			],
			'ifPeople' => [
				'title'		=> 'Show People',
				'type'		=> 'checkbox',
				'group'		=> 'Extra Fields',
				'showExternalParam' => false,
				'default'	=> false
			],
			'sendDetailEmail' => [
				'title'        => 'Send Details Email',
				'type'         => 'checkbox',
				'default'      => false,
				'group'		   => 'On Send',
				'showExternalParam' => false,
			],
			'sendEmail' => [
				'title'        => 'Email to send',
				'type'         => 'string',
				'group'		   => 'On Send',
				'showExternalParam' => false,
			],
			'sendReply' => [
				'title'        => 'Send AutoReply Email',
				'type'         => 'checkbox',
				'default'      => false,
				'group'		   => 'On Send',
				'showExternalParam' => false,
			],
		];
	}

	protected function prepareVars(){
		$this->inputClass = $this->property('inputClass');
		$this->groupClass = $this->property('groupClass');
		$this->ifLabel = $this->property('ifLabel');
		$this->ifInline = $this->property('ifInline');
		$this->icons = $this->property('icons');
		$this->submitClass = $this->property('submitClass');
		$this->ifPhone = $this->property('ifPhone');
		$this->ifCheckout = $this->property('ifCheckout');
		$this->ifPeople = $this->property('ifPeople');
	}

	public function onRun(){
		$this->prepareVars();

		$this->addCss('/plugins/netsti/hotel/assets/css/animate.css');
		$this->addCss('/plugins/netsti/hotel/assets/css/components.css');
		$this->addJs('/plugins/netsti/hotel/assets/js/pickaday.js');
		$this->addJs('/plugins/netsti/hotel/assets/js/components.js');
	}

	public function componentDetails()
	{
		return [
			'name' => 'Booking Form',
			'description' => 'Add Booking Form Integration.'
		];
	}

	public function onBookForm()
	{
		$data = post();

		$rules = [
			'name'  => 'required|between:2,64',
			'email' => 'required|email|between:8,64',
			'arrive_date' => 'required'
		];

		$validation = Validator::make($data, $rules);
		if ($validation->fails()) {
			$this->page['validation'] = $validation;
			return 'error';
		}

		$booking = new BookingModel();
		$booking->name = $data['name'];
		$booking->email = $data['email'];
		$booking->arrive_date = strtotime($data['arrive_date']);

		if(isset($data['phone']))
			$booking->phone = $data['phone'];
		if(isset($data['checkout_date']))
			$booking->checkout_date = strtotime($data['checkout_date']);
		if(isset($data['people']))
			$booking->people = $data['people'];
		$booking->status = 2;

		$booking->save();

		if($this->property('sendDetailEmail')){
			Mail::send('netsti.hotel::mail.booking', [
					'data' => $data, 
					'fields' => Lang::get('netsti.hotel::lang.fields'),
					'url' => Backend::url('netsti/hotel/bookings'), 
					"company" => CompanySettings::instance(),
					'email_line' => Lang::get('netsti.hotel::lang.email_line'),
					'new_booking' => Lang::get('netsti.hotel::lang.new_booking'),
				], function($message) use ($data){
					$message->to($this->property('sendEmail'));
			});
		}

		if($this->property('sendReply')){
			Mail::send('netsti.hotel::mail.reply', [
					'data' => $data, 
					'fields' => Lang::get('netsti.hotel::lang.fields'),
					"company" => CompanySettings::instance(),
					"email" => CompanySettings::instance()->booking,
					'email_line' => Lang::get('netsti.hotel::lang.email_line'),
				], function($message) use ($data){
					$message->to($data['email']);
			});
		}
		
		return 'success';
	}
}
?>