<?php namespace NetSTI\Hotel\Controllers;

use NetSTI\Hotel\Models\Booking as BookingModel;
use Backend\Classes\Controller;
use BackendMenu;
use Flash;
use Lang;

class Bookings extends Controller
{
    public $implement = ['Backend\Behaviors\ListController','Backend\Behaviors\FormController'];
    
    public $listConfig = 'config_list.yaml';
    public $formConfig = 'config_form.yaml';

    public $requiredPermissions = [
        'netsti.hotel.bookings' 
    ];

    public function __construct()
    {
        parent::__construct();
        BackendMenu::setContext('NetSTI.Hotel', 'hotel', 'booking');
    }

    // METODOS
	public function onCreateForm(){
		$this->asExtension('FormController')->create(post('record_id'));
		$this->vars['recordId'] = post('record_id');
		return $this->makePartial('create');
	}

	public function onCreate(){
		$this->asExtension('FormController')->create_onSave();
		return $this->listRefresh();
	}

	public function onUpdateForm(){
		$this->asExtension('FormController')->update(post('record_id'));
		$this->vars['recordId'] = post('record_id');
		return $this->makePartial('update');
	}

	public function onUpdate(){
		$this->asExtension('FormController')->update_onSave(post('record_id'));
		return $this->listRefresh();
	}

	public function onDelete(){
		$this->asExtension('FormController')->update_onDelete(post('record_id'));
		return $this->listRefresh();
	}

	public function index_onArchive(){
		if (($checkedIds = post('checked')) && is_array($checkedIds) && count($checkedIds)) {

			foreach ($checkedIds as $itemId) {
				if (!$item = BookingModel::find($itemId))
					continue;

				$item->status = 0;
				$item->save();
			}

			Flash::success(Lang::get('netsti.hotel::lang.archive_msj'));
		} else {
			Flash::error(Lang::get('netsti.hotel::lang.archive_error'));
		}

		return $this->listRefresh();
	}
}