<?php namespace NetSTI\Hotel\Models;

use Model;
use Backend;

class Booking extends Model{
	// VALIDATIONS RULES
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		'name' => ['required','min:5'],
		'email' => ['required','email']
	];

	// PROPERTIES
	protected $table = 'netsti_hotel_bookings';
	protected $guarded = [];
	protected $dates = ['arrive_date', 'checkout_date'];

	// RELATIONS
	public $hasOne = [];
	public $hasMany = [];
	public $belongsTo = [];
	public $belongsToMany = [];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];
	public $attachOne = [];
	public $attachMany = [];
}