<?php namespace NetSTI\Hotel\Models;

use Model;
use ValidationException;
use NetSTI\Hotel\Models\Settings;

class Room extends Model{
	// Model Validation
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		"roomtype" => "required",
		"number" => ["required","integer"],
		"max_persons" => ["required","integer"],
		"floor" => "required"
	];

	// Database Table
	public $table = 'netsti_hotel_rooms';

	// Model Configuration
	public $implement = ['RainLab.Translate.Behaviors.TranslatableModel'];
	public $translatable = ['name','description'];
	protected $guarded = [];
	protected $jsonable = ['beds'];

	// Relations
	public $hasOne = [];
	public $hasMany = [];
	public $belongsTo = [
		'roomtype' => ['NetSTI\Hotel\Models\Roomtype']
	];
	public $belongsToMany = [];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];

	// Attachments
	public $attachOne = [];
	public $attachMany = [
		'pictures' => ['System\Models\File']
	];

	public function getFloorOptions(){
		$data = [];
		foreach (Settings::get('levels') as $key => $value) {
			$data[$key] = $value['level'];
		}
		return $data;
	}

	public function getBedOptions(){
		$data = [];
		foreach (Settings::get('beds') as $value) {
			$data[$value['bed']] = $value['bed'];
		}
		return $data;
	}
}

?>