<?php namespace NetSTI\Hotel\Models;

use Model;
use ValidationException;

class Roomtype extends Model{
	// Model Validation
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		
	];

	// Database Table
	public $table = 'netsti_hotel_rooms_type';

	// Model Configuration
	public $implement = ['RainLab.Translate.Behaviors.TranslatableModel'];
	public $translatable = ['name','description'];
	protected $guarded = [];

	// Relations
	public $hasOne = [];
	public $hasMany = [
		'rooms' => ['NetSTI\Hotel\Models\Room']
	];
	public $belongsTo = [];
	public $belongsToMany = [];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];

	// Attachments
	public $attachOne = [
		'picture' => ['System\Models\File']
	];
	public $attachMany = [
		'pictures' => ['System\Models\File']
	];
}

?>