<?php namespace NetSTI\Hotel\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateBookingsTable extends Migration
{

	public function up()
	{
		Schema::create('netsti_hotel_bookings', function($table){
			$table->engine = 'InnoDB';
			$table->increments('id');
			$table->string('name');
			$table->string('email');
			$table->string('phone')->nullable();
			$table->datetime('arrive_date');
			$table->datetime('checkout_date')->nullable();
			$table->string('company')->nullable();
			$table->integer('people')->default(1);
			$table->integer('status')->default(2);
			$table->timestamps();
		});

		Schema::create('netsti_hotel_bookings_rooms', function($table){
			$table->engine = 'InnoDB';
			$table->integer('booking_id')->unsigned();
			$table->integer('room_id')->unsigned();
			$table->primary(['booking_id', 'room_id'], 'booking_room');
		});
	}

	public function down()
	{
		Schema::drop('netsti_hotel_bookings');
		Schema::drop('netsti_hotel_bookings_rooms');
	}

}
