<?php namespace NetSTI\Hotel\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateRoomsTable extends Migration
{

	public function up()
	{
		Schema::create('netsti_hotel_rooms', function($table){
			$table->engine = 'InnoDB';
			$table->increments('id');
			$table->string('roomtype_id')->index();
			$table->integer('number')->nullable();
			$table->text('description')->nullable();
			$table->integer('max_persons')->default(1);
			$table->json('beds');
			$table->integer('floor');

			$table->integer('is_available')->default(false);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('netsti_hotel_rooms');
	}

}
