<?php namespace NetSTI\System;

use App;
use File;
use Event;
use Config;
use Backend;
use System\Classes\PluginBase;
use NetSTI\System\Models\Inbox;
use NetSTI\System\Models\String;
use NetSTI\System\Models\Gallery;
use Illuminate\Foundation\AliasLoader;

class Plugin extends PluginBase{
	// REQUIRED PLUGINS
	public $require = ['RainLab.Translate'];

	// DETAILS
	public function pluginDetails(){
		return [
			'name'        => 'netsti.system::lang.plugin.name',
			'description' => 'netsti.system::lang.plugin.description',
			'author'      => 'NetSTI',
			'icon'        => 'icon-bullseye'
		];
	}

	// COMPONENTS
	public function registerComponents(){
		return [
			'NetSTI\System\Components\Inbox' => 'inboxForm',
			'NetSTI\System\Components\Subscribe' => 'subscribeForm',
			'NetSTI\System\Components\Testimonials' => 'testimonialsComp',
			'NetSTI\System\Components\Strings' => 'stringsComp',
			'NetSTI\System\Components\Company' => 'companyData',
		];
	}

	// PERMISSIONS
	public function registerPermissions(){
		return [
			'netsti.system.conections.contacts' => [
				'tab' => 'netsti.system::lang.menu.conections',
				'label' => 'netsti.system::lang.contacts.plural'
			],
			'netsti.system.conections.events' => [
				'tab' => 'netsti.system::lang.menu.conections',
				'label' => 'netsti.system::lang.calendars.title'
			],
			'netsti.system.conections.inbox' => [
				'tab' => 'netsti.system::lang.menu.conections',
				'label' => 'netsti.system::lang.inbox.title'
			],
			'netsti.system.conections.subscribers' => [
				'tab' => 'netsti.system::lang.menu.conections',
				'label' => 'netsti.system::lang.subscribers.plural'
			],

			'netsti.system.sales.opportunities' => [
				'tab' => 'netsti.system::lang.menu.sales',
				'label' => 'netsti.system::lang.opportunities.plural'
			],
			'netsti.system.sales.products' => [
				'tab' => 'netsti.system::lang.menu.sales',
				'label' => 'netsti.system::lang.products.plural'
			],
			'netsti.system.sales.estimates' => [
				'tab' => 'netsti.system::lang.menu.sales',
				'label' => 'netsti.system::lang.estimates.plural'
			],

			'netsti.system.accounting.expenses' => [
				'tab' => 'netsti.system::lang.menu.accounting',
				'label' => 'netsti.system::lang.expenses.plural'
			],
			'netsti.system.accounting.invoices' => [
				'tab' => 'netsti.system::lang.menu.accounting',
				'label' => 'netsti.system::lang.invoices.plural'
			],

			'netsti.system.frontend.strings' => [
				'tab' => 'netsti.system::lang.menu.frontend',
				'label' => 'netsti.system::lang.strings.plural'
			],
			'netsti.system.frontend.testimonials' => [
				'tab' => 'netsti.system::lang.menu.frontend',
				'label' => 'netsti.system::lang.testimonials.plural'
			],
		];
	}

	// MENU AND NAVIGATIONS
	public function registerNavigation(){
		return [
			'conections' => [
				'label'       => 'netsti.system::lang.menu.conections',
				'url'         => Backend::url('netsti/system/conections'),
				'icon'        => 'icon-users',
				'permissions' => ['netsti.system.conections.*'],
				'order'       => 300,

				'sideMenu' => [
					'dashboard' => [
						'label'       => 'netsti.system::lang.dashboard',
						'icon'        => 'icon-pie-chart',
						'url'         => Backend::url('netsti/system/conections'),
						'permissions' => ['netsti.system.conections.*']
					],
					'contacts' => [
						'label'       => 'netsti.system::lang.contacts.plural',
						'icon'        => 'icon-phone',
						'url'         => Backend::url('netsti/system/contacts'),
						'permissions' => ['netsti.system.conections.contacts']
					],
					'events' => [
						'label'       => 'netsti.system::lang.calendars.title',
						'icon'        => 'icon-calendar',
						'url'         => Backend::url('netsti/system/events'),
						'permissions' => ['netsti.system.conections.events']
					],
					'inbox' => [
						'label'       => 'netsti.system::lang.inbox.title',
						'icon'        => 'icon-inbox',
						'url'         => Backend::url('netsti/system/inbox'),
						'permissions' => ['netsti.system.conections.inbox'],
						'counter'     => ($r = Inbox::where('ready', 0)->count() > 0) ? $r : null
					],
					'subscribers' => [
						'label'       => 'netsti.system::lang.subscribers.plural',
						'icon'        => 'icon-rss',
						'url'         => Backend::url('netsti/system/subscribers'),
						'permissions' => ['netsti.system.conections.subscribers']
					],
				]
			],
			'sales' => [
				'label'       => 'netsti.system::lang.menu.sales',
				'url'         => Backend::url('netsti/system/sales'),
				'icon'        => 'icon-bullhorn',
				'permissions' => ['netsti.system.sales.*'],
				'order'       => 301,

				'sideMenu' => [
					'dashboard' => [
						'label'       => 'netsti.system::lang.dashboard',
						'icon'        => 'icon-pie-chart',
						'url'         => Backend::url('netsti/system/sales'),
						'permissions' => ['netsti.system.sales.*']
					],
					'opportunities' => [
						'label'       => 'netsti.system::lang.opportunities.plural',
						'icon'        => 'icon-thumb-tack',
						'url'         => Backend::url('netsti/system/opportunities'),
						'permissions' => ['netsti.system.sales.opportunities']
					],
					'products' => [
						'label'       => 'netsti.system::lang.products.plural',
						'icon'        => 'icon-cubes',
						'url'         => Backend::url('netsti/system/products'),
						'permissions' => ['netsti.system.sales.products']
					],
					'estimates' => [
						'label'       => 'netsti.system::lang.estimates.plural',
						'icon'        => 'icon-calculator',
						'url'         => Backend::url('netsti/system/estimates'),
						'permissions' => ['netsti.system.sales.estimates']
					],
				]
			],
			'accounting' => [
				'label'       => 'netsti.system::lang.menu.accounting',
				'url'         => Backend::url('netsti/system/accounting'),
				'icon'        => 'icon-bank',
				'permissions' => ['netsti.system.accounting.*'],
				'order'       => 302,

				'sideMenu' => [
					'dashboard' => [
						'label'       => 'netsti.system::lang.dashboard',
						'icon'        => 'icon-pie-chart',
						'url'         => Backend::url('netsti/system/accounting'),
						'permissions' => ['netsti.system.accounting.*']
					],
					'expenses' => [
						'label'       => 'netsti.system::lang.expenses.plural',
						'icon'        => 'icon-usd',
						'url'         => Backend::url('netsti/system/expenses'),
						'permissions' => ['netsti.system.accounting.expenses']
					],
					'invoices' => [
						'label'       => 'netsti.system::lang.invoices.plural',
						'icon'        => 'icon-credit-card',
						'url'         => Backend::url('netsti/system/invoices'),
						'permissions' => ['netsti.system.accounting.invoices']
					],
				]
			],
			'frontend' => [
				'label'       => 'netsti.system::lang.menu.frontend',
				'url'         => Backend::url('netsti/system/strings'),
				'icon'        => 'icon-sliders',
				'permissions' => ['netsti.system.frontend.*'],
				'order'       => 303,

				'sideMenu' => [
					'strings' => [
						'label'       => 'netsti.system::lang.strings.plural',
						'icon'        => 'icon-language',
						'url'         => Backend::url('netsti/system/strings'),
						'permissions' => ['netsti.system.frontend.strings']
					],
					'testimonials' => [
						'label'       => 'netsti.system::lang.testimonials.plural',
						'icon'        => 'icon-comments-o',
						'url'         => Backend::url('netsti/system/testimonials'),
						'permissions' => ['netsti.system.frontend.testimonials']
					],
					'gallery' => [
						'label'       => 'netsti.system::lang.galleries.plural',
						'icon'        => 'icon-camera-retro',
						'url'         => Backend::url('netsti/system/galleries'),
						'permissions' => ['netsti.system.frontend.galleries']
					],
				]
			]
		];
	}

	// SETTINGS
	public function registerSettings(){
		return [
			'payment' => [
				'label'       => 'netsti.system::lang.settings.sales_accounting',
				'description' => 'netsti.system::lang.settings.sales_accounting_description',
				'icon'        => 'icon-dollar',
				'class'       => 'NetSTI\System\Models\PaymentsSettings',
				'category'    => 'netsti.system::lang.settings.category_name',
				'order'       => 100,
				'keywords'    => 'crm customer relationship management invoice estimate'
			],
			'slack' => [
				'label'       => 'netsti.system::lang.settings.slack',
				'description' => 'netsti.system::lang.settings.slack_description',
				'icon'        => 'icon-slack',
				'class'       => 'NetSTI\System\Models\SlackSettings',
				'category'    => 'netsti.system::lang.settings.category_name',
				'order'       => 101,
				'keywords'    => 'crm customer relationship management slack'
			],
			'company' => [
				'label'       => 'netsti.system::lang.settings.company',
				'description' => 'netsti.system::lang.settings.company_description',
				'icon'        => 'icon-building-o',
				'class'       => 'NetSTI\System\Models\CompanySettings',
				'category'    => 'netsti.system::lang.settings.category_name',
				'order'       => 102,
				'keywords'    => 'crm customer relationship management company'
			]
		];
	}

	// MARKUP TAGS
	public function registerMarkupTags(){
		return [
			'filters' => [
				'base64img' => [$this, 'makeBase64Img'],
				'base64encode' => [$this, 'makeBase64enc'],
				'base64decode' => [$this, 'makeBase64dec'],
				'strpad' => [$this, 'makeStrPad'],
				'trans' => [$this, 'getStringText'],
				'rtrans' => [$this, 'getStringRich']
			],
			'functions' => [
				'base64img' => [$this, 'makeBase64Img'],
				'base64encode' => [$this, 'makeBase64enc'],
				'base64decode' => [$this, 'makeBase64dec'],
				'strpad' => [$this, 'makeStrPad'],
				'gallery' => [$this, 'getGallery']
			]
		];
	}

	public function getStringText($text){
		$r = String::where('slug',$text)->first();
		return $r->text;
	}

	public function getStringRich($text){
		$r = String::where('slug',$text)->first();
		return $r->richtext;
	}

	public function getGallery($text){
		return Gallery::where('slug',$text)->first();
	}

	public function makeBase64Img($text){
		$type = pathinfo($text, PATHINFO_EXTENSION);
		$data = file_get_contents(base_path().$text);
		return 'data:image/' . $type . ';base64,' . base64_encode($data);
	}

	public function makeBase64enc($text){
		return base64_encode($text);
	}

	public function makeBase64dec($text){
		return base64_decode($text);
	}

	public function makeStrPad($text, $digits){
		return str_pad($text, $digits, 0, STR_PAD_LEFT);
	}

	// MAIL TEMPLATES
	public function registerMailTemplates(){
		return [];

		return [
			'netsti.system::mail.invoice' => 'Sent Invoices to the clients.',
			'netsti.system::mail.estimate' => 'Sent Estimates to the clients.'
		];
	}

	// FORM WIDGETS
	public function registerFormWidgets(){
		return [
			'Owl\FormWidgets\Address\Widget' => [
				'label' => 'Address',
				'code' => 'address'
			],
			'Owl\FormWidgets\Knob\Widget' => [
				'label' => 'Knob',
				'code'  => 'knob'
			],
			'Owl\FormWidgets\Tagbox\Widget' => [
				'label' => 'Tagbox',
				'code'  => 'tagbox'
			],
			'Owl\FormWidgets\HasMany\Widget' => [
				'label' => 'Hasmany',
				'code'  => 'hasmany'
			],
			'Owl\FormWidgets\Comment\Widget' => [
				'label' => 'Comment',
				'code'  => 'comment'
			],
			'Owl\FormWidgets\Money\Widget' => [
				'label' => 'Money',
				'code' => 'money'
			],

			'NetSTI\System\Widgets\RecordFinderCreate' => [
				'label' => 'Record Finder & Create',
				'code' => 'recordcreate'
			],
		];
	}

	public function boot(){
		App::register('Barryvdh\DomPDF\ServiceProvider');

		$alias = AliasLoader::getInstance();
		$alias->alias('PDF', 'Barryvdh\DomPDF\Facade');

		$this->publishes([
			__DIR__ . '/config/dompdf.php' => config_path('dompdf.php'),
		]);

		$this->createFontDirectory();
	}

	private function createFontDirectory(){
		$config = Config::get('dompdf.defines');

		if ( ! File::exists($config['DOMPDF_FONT_CACHE']))
		{
			File::makeDirectory($config['DOMPDF_FONT_CACHE']);
		}
	}

}
