/*
 * HTML5 Sortable jQuery Plugin
 * http://farhadi.ir/projects/html5sortable
 * fork https://github.com/jgauby/html5sortable
 * 
 * Copyright 2012, Ali Farhadi
 * Released under the MIT license.
 *
 * (Modified by to work with OctoberCMS lists)
 */
(function($) {
	var dragging, placeholders = $();
	$.fn.html5sortable = function(options) {
		var method = String(options);
		options = $.extend({
			connectWith: false
		}, options);
		return this.each(function() {
			if (/^enable|disable|destroy$/.test(method)) {
				var items = $(this).children($(this).data('items')).attr('draggable', method == 'enable');
				if (method == 'destroy') {
					items.add(this).removeData('connectWith items')
						.off('dragstart.h5s dragend.h5s selectstart.h5s dragenter.h5s');
				}
				return;
			}
			var isHandle, index, items = $(this).children(options.items);
			var tag_placeholder = 'tr';

			var placeholder = $('<' + tag_placeholder + ' class="sortable-placeholder">');
			items.find(options.handle).mousedown(function() {
				isHandle = true;
			}).mouseup(function() {
					isHandle = false;
				});
			$(this).data('items', options.items)
			placeholders = placeholders.add(placeholder);
			if (options.connectWith) {
				$(options.connectWith).add(this).data('connectWith', options.connectWith);
			}
			items.attr('draggable', 'true').on('dragstart.h5s', function(e) {
				if (options.handle && !isHandle) {
					return false;
				}

				// set placeholders
				var content = $(this).html();
				placeholders.each(function(i, placeholder) {
					$(placeholder).css({'opacity':0.8, 'filter':'alpha(opacity=80)', 'font-weight':'bold'}).html(content);
				});

				isHandle = false;
				var dt = e.originalEvent.dataTransfer;
				dt.effectAllowed = 'move';
				dt.setData('Text', 'dummy');
				index = (dragging = $(this)).addClass('sortable-dragging').index();
			}).on('dragend.h5s', function() {
					if (!dragging) {
						return;
					}
					dragging.removeClass('sortable-dragging').show();
					placeholders.filter(':visible').after(dragging);
					placeholders.detach();
					if (index != dragging.index()) {
						dragging.parent().trigger('sortupdate', {item: dragging});
					}
					dragging = null;
				}).not('a[href], img').on('selectstart.h5s', function() {
					this.dragDrop && this.dragDrop();
					return false;
				}).end().add([this, placeholder]).on('dragenter.h5s', function(e) {
					if (!items.is(dragging) && options.connectWith !== $(dragging).parent().data('connectWith')) {
						return true;
					}
					e.preventDefault();
					e.originalEvent.dataTransfer.dropEffect = 'move';
					if (items.is(this)) {
						if (options.forcePlaceholderSize) {
							placeholder.height(dragging.outerHeight());
						}
						dragging.hide();
						$(this)[placeholder.index() < $(this).index() ? 'after' : 'before'](placeholder);
						placeholders.not(placeholder).detach();
					} else if (!placeholders.is(this) && !$(this).children(options.items).length) {
						placeholders.detach();
						$(this).append(placeholder);
					}
					return false;
				});
		});
	};
})(jQuery);