jQuery(document).ready(function($) {
	if($('.total-widget')){
		setInterval(function() {
			showTotal();
		}, 1000);
	}

	if($('.debits-widget')){
		setInterval(function() {
			showDebits();
		}, 1000);
	}

	console.info('LOADED');

	function showTotal(){
		$tw = $('.total-widget');
		$val = $('.update').attr('total')*1.00;

		$total = 0;
		$('[data-total-field]').each(function(index, el) {
			$total += parseFloat($(el).data('total-field'))*1.00;
		});

		if($val != $total){
			$tw.hide().html($total.formatMoney(2, '.', ',')).show('fast');
			$('.update').attr('total', $total);
			$.get($('.update').attr('url'));
		}
	}

	function showDebits(){
		$dw = $('.debits-widget');
		$val = $('.debit').attr('total-paid')*1.00;

		$total = 0;
		$('[data-payment-field]').each(function(index, el) {
			$total += parseFloat($(el).data('payment-field'))*1.00;
		});
		$credit = $('.debit').attr('total')*1.00 - $total;

		if($val != $total){
			$dw.hide().html($total.formatMoney(2, '.', ',')).show('fast');
			$('.debit').attr('total-paid', $total);
			$('.credit').html(' - loading -');
			$.get($('.debit').attr('url')).done(function(){
				$('.credit').hide().html($credit.formatMoney(2, '.', ',')).show('fast');
				if($credit == 0){
					$("html, body").animate({ scrollTop: 0 }, "fast");
					location.reload();
				}
			});
		}
	}

	Number.prototype.formatMoney = function(c, d, t){
		var n = this, 
		c = isNaN(c = Math.abs(c)) ? 2 : c, 
		d = d == undefined ? "." : d, 
		t = t == undefined ? "," : t, 
		s = n < 0 ? "-" : "", 
		i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "", 
		j = (j = i.length) > 3 ? j % 3 : 0;
		return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
	};
});