<?php namespace NetSTI\System\Components;

use Lang;
use Flash;
use Validator;
use ValidationException;
use NetSTI\System\Models\Inbox as InboxModel;

class Inbox extends \Cms\Classes\ComponentBase
{
	public function componentDetails()
	{
		return [
			'name' => 'Inbox Form',
			'description' => 'Add Contact Form Integration.'
		];
	}

	public function onContact()
	{
		$data = post();

		$rules = [
			'name'  => 'required|between:2,64',
			'email' => 'required|email|between:8,64',
		];

		$validation = Validator::make($data, $rules);
		if ($validation->fails()) {
			throw new ValidationException($validation);
		}

		$inbox = new InboxModel();
		$inbox->name = $data['name'];
		$inbox->email = $data['email'];
		if(isset($data['phone']))
			$inbox->phone = $data['phone'];
		if(isset($data['company']))
			$inbox->company = $data['company'];
		else
			$inbox->company = Lang::get('netsti.system::lang.none');
		if(isset($data['subject']))
			$inbox->subject = $data['subject'];
		$inbox->message = $data['message'];

		$inbox->save();
		return;
	}
}
?>