<?php namespace NetSTI\System\Components;

use NetSTI\System\Models\String;
use Illuminate\Support\Facades\Schema;

class Strings extends \Cms\Classes\ComponentBase{

	public function componentDetails()
	{
		return [
			'name'        => 'netsti.system::lang.strings.plural',
			'description' => 'netsti.system::lang.strings.description',
		];
	}

	public function onRun()
	{
		$strings = String::all();
		$text = [];
		$rich = [];
		foreach ($strings as $item) {
			$text[$item->slug] = $item->text;
			$rich[$item->slug] = $item->richtext;
		}
		$this->page['_'] = $text;
		$this->page['__'] = $rich;
	}
}
