<?php namespace NetSTI\System\Components;

use Lang;
use Flash;
use Validator;
use ValidationException;
use NetSTI\System\Models\Subscriber as SubscriberModel;

class Subscribe extends \Cms\Classes\ComponentBase{
	public function componentDetails(){
		return [
			'name' => 'Subscribe Form',
			'description' => 'Add Subscribe Form Integration.'
		];
	}

	public function onSubscribe(){
		$data = post();

		$rules = [
			'name'  => 'between:2,100',
			'email' => ['required','email','unique:netsti_system_subscribers']
		];

		$validation = Validator::make($data, $rules);
		if ($validation->fails()) {
			throw new ValidationException($validation);
		}

		$subscriber = new SubscriberModel();
		$subscriber->name = $data['name'];
		$subscriber->email = $data['email'];
		if(isset($data['common']))
			$subscriber->phone = $data['common'];

		$subscriber->save();
		return;
	}
}
?>