<?php namespace NetSTI\System\Components;

use NetSTI\System\Models\Testimonial;
use Illuminate\Support\Facades\Schema;

class Testimonials extends \Cms\Classes\ComponentBase{

	public function componentDetails()
	{
		return [
			'name'        => 'netsti.system::lang.testimonials.plural',
			'description' => 'netsti.system::lang.testimonials.description',
		];
	}

	public function onRun()
	{
		if (is_numeric($id = $this->property('itemId'))) {
			$this->page['testimonial'] = Testimonial::whereId($id)->with('picture')->first();
		} else {
			$this->page['testimonials'] = Testimonial::take(5)->get();
		}
	}

	public function getOrderByOptions()
	{
		$schema = Schema::getColumnListing('netsti_system_testimonials');
		foreach ($schema as $column) {
			$options[$column] = ucwords(str_replace('_', ' ', $column));
		}
		return $options;
	}
}
