<?php namespace NetSTI\System\Controllers;

use Lang;
use Flash;
use BackendMenu;
use Backend\Classes\Controller;
use NetSTI\System\Models\Status;

class Accounts extends Controller{
	public $implement = [
		'Backend.Behaviors.FormController',
		'Backend.Behaviors.ListController',
		'Backend.Behaviors.ReorderController',
		'Owl.Behaviors.ListDelete.Behavior',
	];

	public $formConfig = 'config_form.yaml';
	public $listConfig = 'config_list.yaml';
	public $reorderConfig = 'config_reorder.yaml';

	public $requiredPermissions = ['netsti.system.accounting.expenses'];

	public function __construct(){
		parent::__construct();

		BackendMenu::setContext('NetSTI.System', 'accounting', 'expenses');

		$this->addCss('/plugins/netsti/system/assets/css/sortable.css');
	}
}
