<?php namespace NetSTI\System\Controllers;

use BackendMenu;
use Backend\Classes\Controller;

class Contacts extends Controller
{
    public $implement = [
        'Backend.Behaviors.FormController',
        'Backend.Behaviors.ListController',
        'Backend.Behaviors.ImportExportController',
        'Owl.Behaviors.ListDelete.Behavior',
    ];

    public $formConfig = 'config_form.yaml';
    public $listConfig = 'config_list.yaml';
    public $importExportConfig = 'config_import_export.yaml';

    public $requiredPermissions = ['netsti.system.conections.contacts'];

    public function __construct()
    {
        parent::__construct();

        BackendMenu::setContext('NetSTI.System', 'conections', 'contacts');
    }
}