<?php namespace NetSTI\System\Controllers;

use PDF;
use Mail;
use Lang;
use Flash;
use Storage;
use BackendMenu;
use Backend\Classes\Controller;
use NetSTI\System\Models\Estimate;
use NetSTI\System\Models\CompanySettings;
use NetSTI\System\Models\PaymentsSettings;

class Estimates extends Controller{
	public $implement = [
		'Backend.Behaviors.FormController',
		'Backend.Behaviors.ListController',
		'Backend.Behaviors.RelationController',
		'Owl.Behaviors.ListDelete.Behavior',
	];

	public $formConfig = 'config_form.yaml';
	public $listConfig = 'config_list.yaml';
	public $relationConfig = 'config_relation.yaml';

	public $requiredPermissions = ['netsti.system.sales.estimates'];

	public function __construct(){
		parent::__construct();

		BackendMenu::setContext('NetSTI.System', 'sales', 'estimates');
	}

	public function getDataPrint($id){
		return array(
			"document" => Estimate::find($id),
			"settings" => PaymentsSettings::instance(),
			"company"  => CompanySettings::instance(),
			"currency"  => PaymentsSettings::getCurrencyData(),
			"labels" => [
				"email" => Lang::get("netsti.system::lang.contacts.email"),
				"tel" => Lang::get("netsti.system::lang.contacts.phone"),
				"estimate" => Lang::get("netsti.system::lang.estimates.title"),
				"for" => Lang::get("netsti.system::lang.estimates.for"),
				"to" => Lang::get("netsti.system::lang.estimates.to"),
				"date" => Lang::get("netsti.system::lang.estimates.date"),
				"range" => Lang::get("netsti.system::lang.estimates.range"),
				"date_limit" => Lang::get("netsti.system::lang.estimates.date_limit"),
				"by" => Lang::get("netsti.system::lang.estimates.by"),
				"products" => Lang::get("netsti.system::lang.products.plural"),
				"discount" => Lang::get("netsti.system::lang.estimates.discount"),
				"quantity" => Lang::get("netsti.system::lang.products.quantity"),
				"tax" => Lang::get("netsti.system::lang.estimates.tax"),
				"price" => Lang::get("netsti.system::lang.products.price"),
				"total" => Lang::get("netsti.system::lang.products.total"),
				"note" => Lang::get("netsti.system::lang.estimates.note"),
			]
		);
	}

	public function pdf($id){
		try{
			$pdf = PDF::loadView('netsti.system::pdf.simple_invoice', $this->getDataPrint($id));
			return $pdf->stream();
		} catch (Exception $e){
			Flash::error($e->getMessage());
		}
	}

	public function preview_onMail($id){
		ini_set('max_execution_time', 360);
		if($inv = Estimate::find($id)){
			$data = array(
				'to' => $inv->contact->email,
				'name' => $inv->contact->name,
				'subject' => 'Estimate '.$inv->label_nid
			);

			$pdf = PDF::loadView('netsti.system::pdf.simple_invoice', $this->getDataPrint($id));

			Storage::disk('local')->put('estimate.pdf', $pdf->stream());

			Mail::send('netsti.system::mail.estimate', $this->getDataPrint($id), function($message) use ($data){
				$message->to($data['to'], $data['name']);
				$message->attach(storage_path('app/estimate.pdf'));
			});

			Flash::success(Lang::get('netsti.system::lang.estimates.send_success'));
		}else
			Flash::error(Lang::get('netsti.system::lang.estimates.send_error'));
	}
	
	public function totalUpdate($id){
		$inv = Estimate::find($id);
		$inv->saveTotal();
		$inv->save();
	}
}
