<?php namespace NetSTI\System\Controllers;

use BackendMenu;
use Backend\Classes\Controller;

class Events extends Controller{
    public $implement = [
        'Backend.Behaviors.FormController',
        'Backend.Behaviors.ListController',
        'Owl.Behaviors.ListDelete.Behavior',
    ];

    public $formConfig = 'config_form.yaml';
    public $listConfig = 'config_list.yaml';

    public $requiredPermissions = ['netsti.system.conections.events'];

    public function __construct(){
        parent::__construct();

        BackendMenu::setContext('NetSTI.System', 'conections', 'events');
    }

	public function calendar(){
        $this->addCss('/plugins/netsti/system/assets/css/fullcalendar.css');
        
        $this->addJs('/plugins/netsti/system/assets/js/moment.min.js');
        $this->addJs('/plugins/netsti/system/assets/js/fullcalendar.min.js');
        $this->addJs('/plugins/netsti/system/assets/js/calendar.js');

		return $this->makePartial('calendar');
	}
}
