<?php namespace NetSTI\System\Controllers;

use BackendMenu;
use Backend\Classes\Controller;
use NetSTI\System\Models\Expense;

class Expenses extends Controller
{
	public $implement = [
		'Backend.Behaviors.FormController',
		'Backend.Behaviors.ListController',
		'Backend.Behaviors.ImportExportController',
		'Owl.Behaviors.ListDelete.Behavior',
	];

	public $formConfig = 'config_form.yaml';
	public $listConfig = 'config_list.yaml';
	public $importExportConfig = 'config_import_export.yaml';

	public $requiredPermissions = ['netsti.system.accounting.expenses'];

	public function __construct()
	{
		parent::__construct();

		BackendMenu::setContext('NetSTI.System', 'accounting', 'expenses');
	}

	public function index()
	{
		$actualMonth = date('m');
		$lastMonth = date('m')==1 ? 12 : date('m')-1;
		$monthExpenses = Expense::getMonthAmount($actualMonth);
		$lastMonthExpenses = Expense::getMonthAmount($lastMonth);

		$this->vars['monthExpenses'] = $monthExpenses['expenses'];
		$this->vars['monthIncomings'] = $monthExpenses['incomings'];
		$this->vars['lastMonthExpenses'] = $lastMonthExpenses['expenses'];
		$this->vars['lastMonthIncomings'] = $lastMonthExpenses['incomings'];
		$this->vars['totalMonthAmount'] = $monthExpenses['total'];
		$this->vars['totalLastMonthAmount'] = $lastMonthExpenses['total'];

		$this->vars['expenses'] = $monthExpenses['countExpenses'];
		$this->vars['incomings'] = $monthExpenses['countIncomings'];

		$this->asExtension('ListController')->index();
	}
}