<?php namespace NetSTI\System\Controllers;

use Lang;
use Flash;
use BackendMenu;
use Backend\Classes\Controller;
use NetSTI\System\Models\Status;

class Statuses extends Controller{
	public $implement = [
		'Backend.Behaviors.FormController',
		'Backend.Behaviors.ListController',
		'Owl.Behaviors.ListDelete.Behavior',
	];

	public $formConfig = 'config_form.yaml';
	public $listConfig = 'config_list.yaml';

	public $requiredPermissions = ['netsti.system.sales.opportunities'];

	public function __construct(){
		parent::__construct();

		BackendMenu::setContext('NetSTI.System', 'sales', 'opportunities');

		// Grab the drag and drop requirements
		$this->addCss('/plugins/netsti/system/assets/css/sortable.css');
		$this->addJs('/plugins/netsti/system/assets/js/html5sortable.js');
		$this->addJs('/plugins/netsti/system/assets/js/sortable.js');
	}

	public function listExtendQuery($query, $definition = null){
		$query->orderBy('position', 'asc');
	}

	public function index_onUpdatePosition(){
		$moved = [];
		$position = 0;
		if (($reorderIds = post('checked')) && is_array($reorderIds) && count($reorderIds)) {
			foreach ($reorderIds as $id) {
				if (in_array($id, $moved) || !$record = Status::find($id))
					continue;
				$record->position = $position;
				$record->save();
				$moved[] = $id;
				$position++;
			}
			Flash::success(Lang::get('netsti.system::lang.reorder'));
		}
		return $this->listRefresh();
	}
}
