<?php namespace NetSTI\System\Models;

use Model;
use Backend;
use ValidationException;

class Account extends Model{

	// SHORTABLE
	use \October\Rain\Database\Traits\NestedTree;

	// VALIDATIONS RULES
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		'name' => ['required', 'min:3'],
		'color' => 'required'
	];

	// PROPERTIES
	protected $table = 'netsti_system_accounts';
	protected $fillable  = [];
	protected $guarded = [];
	protected $jsonable = [];

	// RELATIONS
	public $hasOne = [];
	public $hasMany = [];
	public $belongsTo = [];
	public $belongsToMany = [];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];
	public $attachOne = [];
	public $attachMany = [];
}