<?php namespace NetSTI\System\Models;

use Model;

class Calendar extends Model{
	// VALIDATIONS RULES
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		'title'  => 'between:3,100',
		'color' => 'required'
	];

	// TRASLATABLE
	public $implement = ['RainLab.Translate.Behaviors.TranslatableModel'];
	public $translatable = ['title'];

	// PROPERTIES
	protected $table = 'netsti_system_calendars';
	protected $guarded = [];

	// RELATIONS
	public $hasOne = [];
	public $hasMany = [];
	public $belongsTo = [];
	public $belongsToMany = [];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];
	public $attachOne = [];
	public $attachMany = [];
}
