<?php namespace NetSTI\System\Models;

use Model;
use Backend;
use ValidationException;

class Category extends Model{

	// VALIDATIONS RULES
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		'name' => ['required','unique:netsti_system_categories'],
		'slug' => ['required','unique:netsti_system_categories'],
	];

	// TRASLATABLE
	public $implement = ['RainLab.Translate.Behaviors.TranslatableModel'];
	public $translatable = ['name'];

	// PROPERTIES
	protected $table = 'netsti_system_categories';
	protected $fillable  = ['name', 'slug'];
	protected $guarded = [];
	protected $jsonable = [];

	// RELATIONS
	public $hasOne = [];
	public $hasMany = [];
	public $belongsTo = [];
	public $belongsToMany = [];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];
	public $attachOne = [];
	public $attachMany = [];

	public function setUrl($pageName, $controller){
		$params = [
			'id'   => $this->id,
			'slug' => $this->slug,
		];

		return $this->url = $controller->pageUrl($pageName, $params);
	}

}