<?php namespace NetSTI\System\Models;

use Model;
use Backend;
use ValidationException;

class Contact extends Model{

	// VALIDATIONS RULES
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		'name' => ['required','min:5'],
		'email' => ['required','email','unique:netsti_system_contacts'],
		'company' => 'required'
	];

	// PROPERTIES
	protected $table = 'netsti_system_contacts';
	protected $guarded = [];
	protected $jsonable = [];

	// RELATIONS
	public $hasOne = [];
	public $hasMany = [];
	public $belongsTo = [];
	public $belongsToMany = [];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];
	public $attachOne = [];
	public $attachMany = [];


}