<?php namespace NetSTI\System\Models;

use Model;
use NetSTI\System\Models\Calendar;

class Event extends Model{
	// VALIDATIONS RULES
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		'title'  => 'between:3,100',
		'start_date' => ['required','date'],
		'end_date' => ['required','date']
	];

	// TRASLATABLE
	public $implement = ['RainLab.Translate.Behaviors.TranslatableModel'];
	public $translatable = ['title'];

	// PROPERTIES
	protected $table = 'netsti_system_events';
	protected $guarded = [];
	protected $dates = ['start_date', 'end_date'];

	// RELATIONS
	public $hasOne = [];
	public $hasMany = [];
	public $belongsTo = [
		'calendar' => ['NetSTI\System\Models\Calendar']
	];
	public $belongsToMany = [];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];
	public $attachOne = [];
	public $attachMany = [];
}
