<?php namespace NetSTI\System\Models;

use Model;
use Backend;
use ValidationException;

class ExpensePayment extends Model{

	// VALIDATIONS RULES
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		'amount' => 'required',
		'expense_at' => 'required'
	];

	// PROPERTIES
	protected $table = 'netsti_system_expenses';
	protected $dates = ['expense_at'];
	protected $guarded = [];
	protected $jsonable = [];

	// RELATIONS
	public $hasOne = [];
	public $hasMany = [];
	public $belongsTo = [
		'account' => ['NetSTI\System\Models\Account']
	];
	public $belongsToMany = [];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];
	public $attachOne = [
		'invoice' => ['System\Models\File']
	];
	public $attachMany = [];

	public function beforeCreate(){
		$this->subject = "Invoice Payment";
		$this->type = 'incoming';
		$this->account = 1;
	}

	public function setData($title, $desc){
		$this->subject = $title;
		$this->description = $desc;
		$this->save();
	}
}