<?php namespace NetSTI\System\Models;

use October\Rain\Database\Pivot;

class InvoiceProductPivot extends Pivot{
	public function beforeSave(){
		$this->calculateTotals();
	}

	public function calculateTotals(){
		$price = $this->price;
		$tax = $price * ($this->tax / 100);
		$total = $this->quantity * ($price + $tax);
		$discount = $total * ($this->discount/100);
		$this->total = $total - $discount;
	}

	public function getTaxOptions(){
		$taxes = Taxdocument::where('status',0)->groupBy('tax_percent')->get();
		foreach ($taxes as $tax) {
			$result[$tax->tax_percent] = $tax->tax_name.' - '.$tax->tax_percent.'%';
		}
		return $result;
	}
}