<?php namespace NetSTI\System\Models;

use Model;
use Backend;
use ValidationException;

class Opportunity extends Model{

	// VALIDATIONS RULES
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		'name' => 'required',
		'status' => 'required',
		'contact' => 'required'
	];

	// PROPERTIES
	protected $table = 'netsti_system_opportunities';
	protected $guarded = [];
	protected $jsonable = [];

	// RELATIONS
	public $hasOne = [];
	public $hasMany = [
		'notes' => ['NetSTI\System\Models\Note'],
	];
	public $belongsTo = [
		'contact' => ['NetSTI\System\Models\Contact'],
		'status' => ['NetSTI\System\Models\Status'],
	];
	public $belongsToMany = [
		'products' => [
			'NetSTI\System\Models\Product',
			'table' => 'netsti_system_opportunities_products',
			'pivot' => ['price', 'description','tax','discount','quantity','total'],
			'pivotModel' => 'NetSTI\System\Models\OpportunityProductPivot'
		],
	];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];
	public $attachOne = [];
	public $attachMany = [];


}