<?php namespace NetSTI\System\Models;

use October\Rain\Database\Model as BaseModel;
use Renatio\DynamicPDF\Models\PDFTemplate;
use NetSTI\System\Models\Taxdocument;

class PaymentsSettings extends BaseModel
{

	public $implement = ['System.Behaviors.SettingsModel'];

	public $settingsCode = 'netsti_system_payments_settings';

	public $settingsFields = 'fields.yaml';

	public $attachOne = [];

	protected static function loadCurrencyData()
	{
		return json_decode(file_get_contents(__DIR__.'/../data/currency.json'), true);
	}

	public function getCurrencyOptions()
	{
		$currency = $this->loadCurrencyData();
		$result = [];

		foreach ($currency as $code=>$data)
			$result[$code] = $data['name']." [".$data['code']."]";

		return $result;
	}

	public static function getCurrencyData()
	{
		$currency = PaymentsSettings::loadCurrencyData();
		return $currency[PaymentsSettings::get('currency')];
	}

	public function getInvoiceDefaultOptions(){
		$result = [];
		foreach (Taxdocument::getTaxDocuments() as $value) {
			$result[$value->id] = $value->doc_type;
		}
		return $result;
	}

	public function getInvoiceTemplateOptions(){
		$result = [];
		foreach (PDFTemplate::all() as $value) {
			$result[$value->code] = $value->title." (".$value->code.")";
		}
		return $result;
	}

	public function getEstimateTemplateOptions(){
		$result = [];
		foreach (PDFTemplate::all() as $value) {
			$result[$value->code] = $value->title." (".$value->code.")";
		}
		return $result;
	}
}
