<?php namespace NetSTI\System\Models;

use Model;
use Backend;
use ValidationException;

class Product extends Model{

	// VALIDATIONS RULES
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		'name' => ['required','unique:netsti_system_products'],
		'slug' => ['required','unique:netsti_system_products'],
		'price' => 'required',
		'quantity' => 'integer'
	];

	// TRASLATABLE
	public $implement = ['RainLab.Translate.Behaviors.TranslatableModel'];
	public $translatable = ['name','brief','content'];

	// PROPERTIES
	protected $table = 'netsti_system_products';
	protected $guarded = [];
	protected $jsonable = [];

	// RELATIONS
	public $hasOne = [];
	public $hasMany = [];
	public $belongsTo = [];
	public $belongsToMany = [
		'categories' => ['NetSTI\System\Models\Category',
			'table' => 'netsti_system_product_categories',
			'order' => 'name'
		]
	];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];
	public $attachOne = [
		'picture' => ['System\Models\File'],
	];
	public $attachMany = [];

	public function afterDelete(){
		$this->picture->delete();
	}

	public function setUrl($pageName, $controller){
		$params = [
			'id'   => $this->id,
			'slug' => $this->slug,
		];

		return $this->url = $controller->pageUrl($pageName, $params);
	}

	public function getTaxOptions(){}
}