<?php namespace NetSTI\System\Models;

use Model;

class Status extends Model{
	// VALIDATIONS RULES
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		'name'  => ['required','between:3,100'],
		'color' => ['required'],
		'probability' => 'required'
	];

	// TRASLATABLE
	public $implement = ['RainLab.Translate.Behaviors.TranslatableModel'];
	public $translatable = ['name'];

	// PROPERTIES
	protected $table = 'netsti_system_statuses';
	protected $guarded = [];
	protected $dates = [];

	// RELATIONS
	public $hasOne = [];
	public $hasMany = [];
	public $belongsTo = [];
	public $belongsToMany = [];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];
	public $attachOne = [];
	public $attachMany = [];
}
