<?php namespace NetSTI\System\Models;

use Model;
use Backend;
use ValidationException;

class String extends Model{

	// VALIDATIONS RULES
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		'slug' => ['required','min:3','unique:netsti_system_strings', 'regex:/^[a-z0-9\/\:_\-\*\[\]\+\?\|]*$/i']
	];

	// TRASLATABLE
	public $implement = ['RainLab.Translate.Behaviors.TranslatableModel'];
	public $translatable = ['text','richtext'];

	// PROPERTIES
	protected $table = 'netsti_system_strings';
	protected $guarded = [];
	protected $jsonable = [];

	// RELATIONS
	public $hasOne = [];
	public $hasMany = [];
	public $belongsTo = [];
	public $belongsToMany = [];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];
	public $attachOne = [];
	public $attachMany = [];
}