<?php namespace NetSTI\System\Models;

use Model;

class Subscriber extends Model{
	// VALIDATIONS RULES
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		'name'  => 'between:1,100',
		'email' => ['required','email','unique:netsti_system_subscribers']
	];

	// PROPERTIES
	protected $table = 'netsti_system_subscribers';
	protected $guarded = [];

	// RELATIONS
	public $hasOne = [];
	public $hasMany = [];
	public $belongsTo = [];
	public $belongsToMany = [];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];
	public $attachOne = [];
	public $attachMany = [];


	public function beforeCreate(){
		$this->created = 1;
		$this->statistics = 0;
	}

	public function beforeUpdate(){
		unset($this->created, $this->statistics);
	}
}
