<?php namespace NetSTI\System\Models;

use Model;
use Backend;
use ValidationException;

class Testimonial extends Model{

	// VALIDATIONS RULES
	use \October\Rain\Database\Traits\Validation;
	public $rules = [
		'content' => ['required','min:5'],
		'source' => 'required',
		'published_at' => ['required', 'date']
	];

	// TRASLATABLE
	public $implement = ['RainLab.Translate.Behaviors.TranslatableModel'];
	public $translatable = ['content','source'];

	// PROPERTIES
	protected $table = 'netsti_system_testimonials';
	protected $guarded = [];
	protected $jsonable = [];

	// RELATIONS
	public $hasOne = [];
	public $hasMany = [];
	public $belongsTo = [];
	public $belongsToMany = [];
	public $morphTo = [];
	public $morphOne = [];
	public $morphMany = [];
	public $attachOne = [
		'picture' => ['System\Models\File'],
	];
	public $attachMany = [];

	public function afterDelete(){
		$this->picture->delete();
	}


}