<?php namespace NetSTI\System\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateEstimatesTable extends Migration
{

	public function up()
	{
		Schema::create('netsti_system_estimates', function($table)
		{
			$table->engine = 'InnoDB';
			$table->increments('id');
			$table->integer('nid')->nullable();
			$table->string('document_nid')->nullable();
			$table->string('label_nid')->nullable();
			$table->timestamp('date')->nullable();
			$table->integer('status')->default(0);
			$table->decimal('total', 15)->default(0);
			$table->integer('contact_id')->unsigned()->nullable()->index();
			$table->integer('owner_id')->unsigned()->nullable()->index();

			$table->timestamps();
		});

		Schema::create('netsti_system_estimates_products', function($table)
		{
			$table->engine = 'InnoDB';
            $table->integer('estimate_id')->unsigned();
            $table->integer('product_id')->unsigned();
            $table->text('description')->nullable();
            $table->integer('tax')->default(0);
            $table->integer('discount')->default(0);
            $table->integer('quantity')->default(1);
            $table->decimal('price', 15)->default(0);
            $table->decimal('total', 15)->default(0);
			$table->primary(['estimate_id', 'product_id'], 'estimate_product');
		});
	}

	public function down()
	{
		Schema::dropIfExists('netsti_system_estimates');
		Schema::dropIfExists('netsti_system_estimates_products');
	}

}
