<?php namespace NetSTI\System\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateEventsTable extends Migration
{

	public function up()
	{
		Schema::create('netsti_system_events', function ($table) {
			$table->engine = 'InnoDB';
			$table->increments('id');
			$table->string('title');
			$table->integer('calendar_id')->unsigned()->nullable()->index();
			$table->datetime('start_date')->nullable();
			$table->datetime('end_date')->nullable();
			$table->nullableTimestamps();
		});
	}

	public function down()
	{
		Schema::dropIfExists('netsti_system_events');
	}

}
