<?php namespace NetSTI\System\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateExpenseTable extends Migration
{

    public function up()
    {
        Schema::create('netsti_system_expenses', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('subject')->nullable();
            $table->text('description')->nullable();
            $table->string('type')->nullable();
            $table->decimal('amount', 15)->default(0);
            $table->integer('account_id')->unsigned()->nullable()->index();
            $table->datetime('expense_at')->nullable();
            $table->timestamps();
        });

        Schema::create('netsti_system_accounts', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->integer('parent_id')->unsigned()->index()->nullable();
            $table->string('name')->nullable();
            $table->string('color')->nullable();
            $table->string('code')->nullable();
            $table->integer('nest_left')->nullable();
            $table->integer('nest_right')->nullable();
            $table->integer('nest_depth')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('netsti_system_expenses');
        Schema::dropIfExists('netsti_system_accounts');
    }

}
