<?php namespace NetSTI\System\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateGalleriesTable extends Migration
{

	public function up()
	{
		Schema::create('netsti_system_galleries', function ($table) {
			$table->engine = 'InnoDB';
			$table->increments('id');
			$table->string('slug');
			$table->string('title');
			$table->longtext('description')->nullable();
			$table->nullableTimestamps();
		});
	}

	public function down()
	{
		Schema::dropIfExists('netsti_system_galleries');
	}

}
