<?php namespace NetSTI\Crm\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateInboxTable extends Migration
{

    public function up()
    {
        Schema::create('netsti_system_inbox', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('subject')->nullable();
            $table->string('company')->nullable();
            $table->text('message')->nullable();
            $table->integer('ready')->default(0);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('netsti_system_inbox');
    }

}
