<?php namespace NetSTI\System\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateInvoicesTable extends Migration
{

	public function up()
	{
		Schema::create('netsti_system_invoices', function($table)
		{
			$table->engine = 'InnoDB';
			$table->increments('id');
			$table->integer('nid')->nullable();
			$table->integer('ifestimate')->default(0);
			$table->string('label_nid')->nullable();
			$table->date('date')->nullable();
			$table->integer('overdue')->default(0);
			$table->integer('status')->default(0);
			$table->decimal('total', 15)->default(0);
			$table->decimal('total_paid', 15)->default(0);

			$table->integer('estimate_id')->unsigned()->nullable()->index();
			$table->integer('taxdocument_id')->unsigned()->nullable()->index();
			$table->integer('contact_id')->unsigned()->nullable()->index();
			$table->integer('owner_id')->unsigned()->nullable()->index();

			$table->timestamps();
		});

		Schema::create('netsti_system_invoices_products', function($table)
		{
			$table->engine = 'InnoDB';
            $table->integer('invoice_id')->unsigned();
            $table->integer('product_id')->unsigned();
            $table->text('description')->nullable();
            $table->integer('tax')->default(0);
            $table->integer('discount')->default(0);
            $table->integer('quantity')->default(1);
            $table->decimal('price', 15)->default(0);
            $table->decimal('total', 15)->default(0);
			$table->primary(['invoice_id', 'product_id'], 'invoice_product');
		});

		Schema::create('netsti_system_invoices_expenses', function($table)
		{
			$table->engine = 'InnoDB';
			$table->integer('invoice_id')->unsigned();
			$table->integer('expense_payment_id')->unsigned();
			$table->primary(['invoice_id', 'expense_payment_id'], 'invoice_expense_payment');
		});
	}

	public function down()
	{
		Schema::dropIfExists('netsti_system_invoices');
		Schema::dropIfExists('netsti_system_invoices_products');
		Schema::dropIfExists('netsti_system_invoices_expenses');
	}

}
