<?php namespace NetSTI\System\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateOpportunitiesTable extends Migration
{

    public function up()
    {
        Schema::create('netsti_system_opportunities', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name')->nullable();
            $table->text('description')->nullable();
            $table->integer('status_id')->unsigned()->nullable()->index();
            $table->integer('contact_id')->unsigned()->nullable()->index();
            $table->timestamp('closed_at')->nullable();
            $table->timestamps();
        });

        Schema::create('netsti_system_opportunities_products', function($table)
        {
            $table->engine = 'InnoDB';
            $table->integer('opportunity_id')->unsigned();
            $table->integer('product_id')->unsigned();
            $table->text('description')->nullable();
            $table->integer('tax')->default(0);
            $table->integer('discount')->default(0);
            $table->integer('quantity')->default(1);
            $table->decimal('price', 15)->default(0);
            $table->decimal('total', 15)->default(0);
            $table->primary(['opportunity_id', 'product_id'], 'opportunity_product');
        });
    }

    public function down()
    {
        Schema::dropIfExists('netsti_system_opportunities');
        Schema::dropIfExists('netsti_system_opportunities_products');
    }

}
