<?php namespace NetSTI\System\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateProductsTable extends Migration
{

    public function up()
    {
        Schema::create('netsti_system_products', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name')->nullable();
            $table->string('slug')->index();
            $table->string('sku')->nullable();
            $table->text('brief')->nullable();
            $table->longText('content')->nullable();
            $table->integer('is_visible')->nullable();
            $table->integer('quantity')->nullable();          
            $table->integer('is_count')->nullable();
            $table->integer('sold_count')->nullable();
            $table->decimal('price', 10, 2)->default(0)->nullable();
            $table->timestamps();
        });

        Schema::create('netsti_system_product_categories', function($table)
        {
            $table->engine = 'InnoDB';
            $table->integer('product_id')->unsigned();
            $table->integer('category_id')->unsigned();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('netsti_system_products');
        Schema::dropIfExists('netsti_system_product_categories');
    }

}
