<?php namespace NetSTI\System\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateStringsTable extends Migration
{

	public function up()
	{
		Schema::create('netsti_system_strings', function ($table) {
			$table->engine = 'InnoDB';
			$table->increments('id');
			$table->string('slug');
			$table->string('text')->nullable();
			$table->longtext('richtext')->nullable();
			$table->nullableTimestamps();
		});
	}

	public function down()
	{
		Schema::dropIfExists('netsti_system_strings');
	}

}
