<?php namespace NetSTI\System\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateTaxDocumentsTable extends Migration
{

    public function up()
    {
        Schema::create('netsti_system_tax_documents', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('doc_type')->nullable();
            $table->string('doc_name')->nullable();
            $table->string('doc_nid')->nullable();
            $table->string('doc_prefix')->nullable();

            $table->integer('init_number')->default(1);
            $table->integer('actual_number')->default(1);
            $table->integer('end_number')->default(100);
            $table->integer('digits')->default(8);
            $table->integer('status')->default(0);

			$table->string('tax_name')->nullable();
			$table->integer('tax_percent')->default(0)->nullable();

            $table->date('start_date');
            $table->date('end_date');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('netsti_system_tax_documents');
    }

}
