<?php namespace NetSTI\Theme\Models;

use Cache;
use October\Rain\Database\Model as BaseModel;

class Settings extends BaseModel{

	public $implement = ['System.Behaviors.SettingsModel', 'RainLab.Translate.Behaviors.TranslatableModel'];

	public $translatable = [
		'marker_title'
	];

	public $settingsCode = 'netsti_theme_settings';

	public $settingsFields = 'fields.yaml';

	public $attachOne = [
		'logo_img' => ['System\Models\File'],
		'logowhite_img' => ['System\Models\File'],
		'main_img' => ['System\Models\File'],
		'testimonials_img' => ['System\Models\File'],
		'facilities_img' => ['System\Models\File']
	];

	public function getWeather(){
		$data = array( 
			"temp" => "~ºC", 
			"icon" => "wi-refresh"
		);

		if (Cache::has('weather')){
			$data = Cache::get('weather');
		}else{

			try{
				$BASE_URL = "http://query.yahooapis.com/v1/public/yql";
				$wt = Settings::get('weather');
				$yql_query = 'select * from weather.forecast where woeid = '.$wt;
				$yql_query_url = $BASE_URL . "?q=" . urlencode($yql_query) . "&format=json";

				$session = curl_init($yql_query_url);
				curl_setopt($session, CURLOPT_RETURNTRANSFER,true);
				$json = curl_exec($session);
				$phpObj =  json_decode($json);
				$weather = $phpObj->query->results->channel->item;

				$icons = array(
					'wi-tornado',
					'wi-day-sleet-storm',
					'wi-hurricane',
					'wi-day-thunderstorm',
					'wi-day-thunderstorm',
					'wi-day-snow',
					'wi-day-sleet-storm',
					'wi-day-sleet-storm',
					'wi-day-showers',
					'wi-day-showers',
					'wi-day-showers',
					'wi-day-showers',
					'wi-day-showers',
					'wi-day-snow',
					'wi-day-snow',
					'wi-day-snow',
					'wi-day-snow',
					'wi-day-hail',
					'wi-day-sleet',
					'wi-dust',
					'wi-day-fog',
					'wi-dust',
					'wi-smoke',
					'wi-snowflake-cold',
					'wi-day-cloudy-gusts',
					'wi-day-cloudy-windy',
					'wi-cloudy',
					'wi-night-cloudy-gusts',
					'wi-day-cloudy-gusts',
					'wi-night-cloudy',
					'wi-day-cloudy',
					'wi-cloudy-gusts',
					'wi-day-sunny',
					'wi-night-clear',
					'wi-day-sunny',
					'wi-rain-mix',
					'wi-day-sunny',
					'wi-storm-showers',
					'wi-storm-showers',
					'wi-storm-showers',
					'wi-showers',
					'wi-rain-mix',
					'wi-snow',
					'wi-rain-mix',
					'wi-cloudy',
					'wi-storm-showers',
					'wi-rain-wind',
					'wi-storm-showers'
				);

				$data["temp"] = @round(5/9*($weather->condition->temp-32))."ºC";
				$data["icon"] = @$icons[$weather->condition->code];

				Cache::put('weather', $data, 1440);
			}catch(Exception $e){
				return $data;
			}
		}

		return $data;
	}

	public function getRates(){
		$rates = array(
			'usd' => 0,
			'eur' => 0
		);

		if (Cache::has('rates')){
			$rates = Cache::get('rates');
		}else{
			$xml = simplexml_load_file('https://www.bac.net/exchangerate/showXmlExchangeRate.do?company=BCO');

			foreach ($xml->country as $val) {
				$country = $val->name;

				if($country == 'Honduras'){
					$rates['usd'] = round((float) $val->saleRateUSD, 2);
					$rates['eur'] = round((float) $val->saleRateEUR, 2);
				}
			}

			Cache::put('rates', $rates, 1440);
		}

		return $rates;
	}

	public function getBeds(){
		$data = [];
		foreach (Settings::get('beds') as $value) {
			$data[] = $value['bed'];
		}
		return $data;
	}
}
