<?php namespace RainLab\Location\Updates;

use October\Rain\Database\Updates\Seeder;
use RainLab\Location\Models\Country;
use RainLab\Location\Models\State;

class SeedAllTables extends Seeder
{
    public function run()
    {
        /*
         * The countries and states table were previously seeded 
         * by RainLab.User so this occurance is detected and halt.
         * @deprecated Safe to remove if year >= 2017
         */
        if (Country::count() > 0) {
            return;
        }

        Country::insert([
            ['is_enabled' => true,  'code' => 'US', 'name' => 'United States'],
            ['is_enabled' => true,  'code' => 'CA', 'name' => 'Canada'],
            ['is_enabled' => true,  'code' => 'AU', 'name' => 'Australia'],
            ['is_enabled' => false, 'code' => 'FR', 'name' => 'France'],
            ['is_enabled' => false, 'code' => 'DE', 'name' => 'Germany'],
            ['is_enabled' => false, 'code' => 'IS', 'name' => 'Iceland'],
            ['is_enabled' => false, 'code' => 'IE', 'name' => 'Ireland'],
            ['is_enabled' => false, 'code' => 'IT', 'name' => 'Italy'],
            ['is_enabled' => false, 'code' => 'ES', 'name' => 'Spain'],
            ['is_enabled' => false, 'code' => 'SE', 'name' => 'Sweden'],
            ['is_enabled' => false, 'code' => 'AT', 'name' => 'Austria'],
            ['is_enabled' => false, 'code' => 'BE', 'name' => 'Belgium'],
            ['is_enabled' => false, 'code' => 'FI', 'name' => 'Finland'],
            ['is_enabled' => false, 'code' => 'CZ', 'name' => 'Czech Republic'],
            ['is_enabled' => false, 'code' => 'DK', 'name' => 'Denmark'],
            ['is_enabled' => false, 'code' => 'NO', 'name' => 'Norway'],
            ['is_enabled' => false, 'code' => 'GB', 'name' => 'United Kingdom'],
            ['is_enabled' => false, 'code' => 'CH', 'name' => 'Switzerland'],
            ['is_enabled' => false, 'code' => 'NZ', 'name' => 'New Zealand'],
            ['is_enabled' => false, 'code' => 'RU', 'name' => 'Russian Federation'],
            ['is_enabled' => false, 'code' => 'PT', 'name' => 'Portugal'],
            ['is_enabled' => false, 'code' => 'NL', 'name' => 'Netherlands'],
            ['is_enabled' => false, 'code' => 'IM', 'name' => 'Isle of Man'],
            ['is_enabled' => false, 'code' => 'AF', 'name' => 'Afghanistan'],
            ['is_enabled' => false, 'code' => 'AX', 'name' => 'Aland Islands '],
            ['is_enabled' => false, 'code' => 'AL', 'name' => 'Albania'],
            ['is_enabled' => false, 'code' => 'DZ', 'name' => 'Algeria'],
            ['is_enabled' => false, 'code' => 'AS', 'name' => 'American Samoa'],
            ['is_enabled' => false, 'code' => 'AD', 'name' => 'Andorra'],
            ['is_enabled' => false, 'code' => 'AO', 'name' => 'Angola'],
            ['is_enabled' => false, 'code' => 'AI', 'name' => 'Anguilla'],
            ['is_enabled' => false, 'code' => 'AQ', 'name' => 'Antarctica'],
            ['is_enabled' => false, 'code' => 'AG', 'name' => 'Antigua and Barbuda'],
            ['is_enabled' => false, 'code' => 'AR', 'name' => 'Argentina'],
            ['is_enabled' => false, 'code' => 'AM', 'name' => 'Armenia'],
            ['is_enabled' => false, 'code' => 'AW', 'name' => 'Aruba'],
            ['is_enabled' => false, 'code' => 'AZ', 'name' => 'Azerbaijan'],
            ['is_enabled' => false, 'code' => 'BS', 'name' => 'Bahamas'],
            ['is_enabled' => false, 'code' => 'BH', 'name' => 'Bahrain'],
            ['is_enabled' => false, 'code' => 'BD', 'name' => 'Bangladesh'],
            ['is_enabled' => false, 'code' => 'BB', 'name' => 'Barbados'],
            ['is_enabled' => false, 'code' => 'BY', 'name' => 'Belarus'],
            ['is_enabled' => false, 'code' => 'BZ', 'name' => 'Belize'],
            ['is_enabled' => false, 'code' => 'BJ', 'name' => 'Benin'],
            ['is_enabled' => false, 'code' => 'BM', 'name' => 'Bermuda'],
            ['is_enabled' => false, 'code' => 'BT', 'name' => 'Bhutan'],
            ['is_enabled' => false, 'code' => 'BO', 'name' => 'Bolivia, Plurinational State of'],
            ['is_enabled' => false, 'code' => 'BQ', 'name' => 'Bonaire, Sint Eustatius and Saba'],
            ['is_enabled' => false, 'code' => 'BA', 'name' => 'Bosnia and Herzegovina'],
            ['is_enabled' => false, 'code' => 'BW', 'name' => 'Botswana'],
            ['is_enabled' => false, 'code' => 'BV', 'name' => 'Bouvet Island'],
            ['is_enabled' => false, 'code' => 'BR', 'name' => 'Brazil'],
            ['is_enabled' => false, 'code' => 'IO', 'name' => 'British Indian Ocean Territory'],
            ['is_enabled' => false, 'code' => 'BN', 'name' => 'Brunei Darussalam'],
            ['is_enabled' => false, 'code' => 'BG', 'name' => 'Bulgaria'],
            ['is_enabled' => false, 'code' => 'BF', 'name' => 'Burkina Faso'],
            ['is_enabled' => false, 'code' => 'BI', 'name' => 'Burundi'],
            ['is_enabled' => false, 'code' => 'KH', 'name' => 'Cambodia'],
            ['is_enabled' => false, 'code' => 'CM', 'name' => 'Cameroon'],
            ['is_enabled' => false, 'code' => 'CV', 'name' => 'Cape Verde'],
            ['is_enabled' => false, 'code' => 'KY', 'name' => 'Cayman Islands'],
            ['is_enabled' => false, 'code' => 'CF', 'name' => 'Central African Republic'],
            ['is_enabled' => false, 'code' => 'TD', 'name' => 'Chad'],
            ['is_enabled' => false, 'code' => 'CL', 'name' => 'Chile'],
            ['is_enabled' => false, 'code' => 'CN', 'name' => 'China'],
            ['is_enabled' => false, 'code' => 'CX', 'name' => 'Christmas Island'],
            ['is_enabled' => false, 'code' => 'CC', 'name' => 'Cocos (Keeling) Islands'],
            ['is_enabled' => false, 'code' => 'CO', 'name' => 'Colombia'],
            ['is_enabled' => false, 'code' => 'KM', 'name' => 'Comoros'],
            ['is_enabled' => false, 'code' => 'CG', 'name' => 'Congo'],
            ['is_enabled' => false, 'code' => 'CD', 'name' => 'Congo, the Democratic Republic of the'],
            ['is_enabled' => false, 'code' => 'CK', 'name' => 'Cook Islands'],
            ['is_enabled' => false, 'code' => 'CR', 'name' => 'Costa Rica'],
            ['is_enabled' => false, 'code' => 'CI', 'name' => 'Cote d\'Ivoire'],
            ['is_enabled' => false, 'code' => 'HR', 'name' => 'Croatia'],
            ['is_enabled' => false, 'code' => 'CU', 'name' => 'Cuba'],
            ['is_enabled' => false, 'code' => 'CW', 'name' => 'Curaçao'],
            ['is_enabled' => false, 'code' => 'CY', 'name' => 'Cyprus'],
            ['is_enabled' => false, 'code' => 'DJ', 'name' => 'Djibouti'],
            ['is_enabled' => false, 'code' => 'DM', 'name' => 'Dominica'],
            ['is_enabled' => false, 'code' => 'DO', 'name' => 'Dominican Republic'],
            ['is_enabled' => false, 'code' => 'EC', 'name' => 'Ecuador'],
            ['is_enabled' => false, 'code' => 'EG', 'name' => 'Egypt'],
            ['is_enabled' => false, 'code' => 'SV', 'name' => 'El Salvador'],
            ['is_enabled' => false, 'code' => 'GQ', 'name' => 'Equatorial Guinea'],
            ['is_enabled' => false, 'code' => 'ER', 'name' => 'Eritrea'],
            ['is_enabled' => false, 'code' => 'EE', 'name' => 'Estonia'],
            ['is_enabled' => false, 'code' => 'ET', 'name' => 'Ethiopia'],
            ['is_enabled' => false, 'code' => 'FK', 'name' => 'Falkland Islands (Malvinas)'],
            ['is_enabled' => false, 'code' => 'FO', 'name' => 'Faroe Islands'],
            ['is_enabled' => false, 'code' => 'FJ', 'name' => 'Fiji'],
            ['is_enabled' => false, 'code' => 'GF', 'name' => 'French Guiana'],
            ['is_enabled' => false, 'code' => 'PF', 'name' => 'French Polynesia'],
            ['is_enabled' => false, 'code' => 'TF', 'name' => 'French Southern Territories'],
            ['is_enabled' => false, 'code' => 'GA', 'name' => 'Gabon'],
            ['is_enabled' => false, 'code' => 'GM', 'name' => 'Gambia'],
            ['is_enabled' => false, 'code' => 'GE', 'name' => 'Georgia'],
            ['is_enabled' => false, 'code' => 'GH', 'name' => 'Ghana'],
            ['is_enabled' => false, 'code' => 'GI', 'name' => 'Gibraltar'],
            ['is_enabled' => false, 'code' => 'GR', 'name' => 'Greece'],
            ['is_enabled' => false, 'code' => 'GL', 'name' => 'Greenland'],
            ['is_enabled' => false, 'code' => 'GD', 'name' => 'Grenada'],
            ['is_enabled' => false, 'code' => 'GP', 'name' => 'Guadeloupe'],
            ['is_enabled' => false, 'code' => 'GU', 'name' => 'Guam'],
            ['is_enabled' => false, 'code' => 'GT', 'name' => 'Guatemala'],
            ['is_enabled' => false, 'code' => 'GG', 'name' => 'Guernsey'],
            ['is_enabled' => false, 'code' => 'GN', 'name' => 'Guinea'],
            ['is_enabled' => false, 'code' => 'GW', 'name' => 'Guinea-Bissau'],
            ['is_enabled' => false, 'code' => 'GY', 'name' => 'Guyana'],
            ['is_enabled' => false, 'code' => 'HT', 'name' => 'Haiti'],
            ['is_enabled' => false, 'code' => 'HM', 'name' => 'Heard Island and McDonald Islands'],
            ['is_enabled' => false, 'code' => 'VA', 'name' => 'Holy See (Vatican City State)'],
            ['is_enabled' => false, 'code' => 'HN', 'name' => 'Honduras'],
            ['is_enabled' => false, 'code' => 'HK', 'name' => 'Hong Kong'],
            ['is_enabled' => false, 'code' => 'HU', 'name' => 'Hungary'],
            ['is_enabled' => false, 'code' => 'IN', 'name' => 'India'],
            ['is_enabled' => false, 'code' => 'ID', 'name' => 'Indonesia'],
            ['is_enabled' => false, 'code' => 'IR', 'name' => 'Iran, Islamic Republic of'],
            ['is_enabled' => false, 'code' => 'IQ', 'name' => 'Iraq'],
            ['is_enabled' => false, 'code' => 'IL', 'name' => 'Israel'],
            ['is_enabled' => false, 'code' => 'JM', 'name' => 'Jamaica'],
            ['is_enabled' => false, 'code' => 'JP', 'name' => 'Japan'],
            ['is_enabled' => false, 'code' => 'JE', 'name' => 'Jersey'],
            ['is_enabled' => false, 'code' => 'JO', 'name' => 'Jordan'],
            ['is_enabled' => false, 'code' => 'KZ', 'name' => 'Kazakhstan'],
            ['is_enabled' => false, 'code' => 'KE', 'name' => 'Kenya'],
            ['is_enabled' => false, 'code' => 'KI', 'name' => 'Kiribati'],
            ['is_enabled' => false, 'code' => 'KP', 'name' => 'Korea, Democratic People\'s Republic of'],
            ['is_enabled' => false, 'code' => 'KR', 'name' => 'Korea, Republic of'],
            ['is_enabled' => false, 'code' => 'KW', 'name' => 'Kuwait'],
            ['is_enabled' => false, 'code' => 'KG', 'name' => 'Kyrgyzstan'],
            ['is_enabled' => false, 'code' => 'LA', 'name' => 'Lao People\'s Democratic Republic'],
            ['is_enabled' => false, 'code' => 'LV', 'name' => 'Latvia'],
            ['is_enabled' => false, 'code' => 'LB', 'name' => 'Lebanon'],
            ['is_enabled' => false, 'code' => 'LS', 'name' => 'Lesotho'],
            ['is_enabled' => false, 'code' => 'LR', 'name' => 'Liberia'],
            ['is_enabled' => false, 'code' => 'LY', 'name' => 'Libyan Arab Jamahiriya'],
            ['is_enabled' => false, 'code' => 'LI', 'name' => 'Liechtenstein'],
            ['is_enabled' => false, 'code' => 'LT', 'name' => 'Lithuania'],
            ['is_enabled' => false, 'code' => 'LU', 'name' => 'Luxembourg'],
            ['is_enabled' => false, 'code' => 'MO', 'name' => 'Macao'],
            ['is_enabled' => false, 'code' => 'MK', 'name' => 'Macedonia'],
            ['is_enabled' => false, 'code' => 'MG', 'name' => 'Madagascar'],
            ['is_enabled' => false, 'code' => 'MW', 'name' => 'Malawi'],
            ['is_enabled' => false, 'code' => 'MY', 'name' => 'Malaysia'],
            ['is_enabled' => false, 'code' => 'MV', 'name' => 'Maldives'],
            ['is_enabled' => false, 'code' => 'ML', 'name' => 'Mali'],
            ['is_enabled' => false, 'code' => 'MT', 'name' => 'Malta'],
            ['is_enabled' => false, 'code' => 'MH', 'name' => 'Marshall Islands'],
            ['is_enabled' => false, 'code' => 'MQ', 'name' => 'Martinique'],
            ['is_enabled' => false, 'code' => 'MR', 'name' => 'Mauritania'],
            ['is_enabled' => false, 'code' => 'MU', 'name' => 'Mauritius'],
            ['is_enabled' => false, 'code' => 'YT', 'name' => 'Mayotte'],
            ['is_enabled' => false, 'code' => 'MX', 'name' => 'Mexico'],
            ['is_enabled' => false, 'code' => 'FM', 'name' => 'Micronesia, Federated States of'],
            ['is_enabled' => false, 'code' => 'MD', 'name' => 'Moldova, Republic of'],
            ['is_enabled' => false, 'code' => 'MC', 'name' => 'Monaco'],
            ['is_enabled' => false, 'code' => 'MN', 'name' => 'Mongolia'],
            ['is_enabled' => false, 'code' => 'ME', 'name' => 'Montenegro'],
            ['is_enabled' => false, 'code' => 'MS', 'name' => 'Montserrat'],
            ['is_enabled' => false, 'code' => 'MA', 'name' => 'Morocco'],
            ['is_enabled' => false, 'code' => 'MZ', 'name' => 'Mozambique'],
            ['is_enabled' => false, 'code' => 'MM', 'name' => 'Myanmar'],
            ['is_enabled' => false, 'code' => 'NA', 'name' => 'Namibia'],
            ['is_enabled' => false, 'code' => 'NR', 'name' => 'Nauru'],
            ['is_enabled' => false, 'code' => 'NP', 'name' => 'Nepal'],
            ['is_enabled' => false, 'code' => 'NC', 'name' => 'New Caledonia'],
            ['is_enabled' => false, 'code' => 'NI', 'name' => 'Nicaragua'],
            ['is_enabled' => false, 'code' => 'NE', 'name' => 'Niger'],
            ['is_enabled' => false, 'code' => 'NG', 'name' => 'Nigeria'],
            ['is_enabled' => false, 'code' => 'NU', 'name' => 'Niue'],
            ['is_enabled' => false, 'code' => 'NF', 'name' => 'Norfolk Island'],
            ['is_enabled' => false, 'code' => 'MP', 'name' => 'Northern Mariana Islands'],
            ['is_enabled' => false, 'code' => 'OM', 'name' => 'Oman'],
            ['is_enabled' => false, 'code' => 'PK', 'name' => 'Pakistan'],
            ['is_enabled' => false, 'code' => 'PW', 'name' => 'Palau'],
            ['is_enabled' => false, 'code' => 'PS', 'name' => 'Palestinian Territory, Occupied'],
            ['is_enabled' => false, 'code' => 'PA', 'name' => 'Panama'],
            ['is_enabled' => false, 'code' => 'PG', 'name' => 'Papua New Guinea'],
            ['is_enabled' => false, 'code' => 'PY', 'name' => 'Paraguay'],
            ['is_enabled' => false, 'code' => 'PE', 'name' => 'Peru'],
            ['is_enabled' => false, 'code' => 'PH', 'name' => 'Philippines'],
            ['is_enabled' => false, 'code' => 'PN', 'name' => 'Pitcairn'],
            ['is_enabled' => false, 'code' => 'PL', 'name' => 'Poland'],
            ['is_enabled' => false, 'code' => 'PR', 'name' => 'Puerto Rico'],
            ['is_enabled' => false, 'code' => 'QA', 'name' => 'Qatar'],
            ['is_enabled' => false, 'code' => 'RE', 'name' => 'Reunion'],
            ['is_enabled' => false, 'code' => 'RO', 'name' => 'Romania'],
            ['is_enabled' => false, 'code' => 'RW', 'name' => 'Rwanda'],
            ['is_enabled' => false, 'code' => 'BL', 'name' => 'Saint Barthélemy'],
            ['is_enabled' => false, 'code' => 'SH', 'name' => 'Saint Helena'],
            ['is_enabled' => false, 'code' => 'KN', 'name' => 'Saint Kitts and Nevis'],
            ['is_enabled' => false, 'code' => 'LC', 'name' => 'Saint Lucia'],
            ['is_enabled' => false, 'code' => 'MF', 'name' => 'Saint Martin (French part)'],
            ['is_enabled' => false, 'code' => 'PM', 'name' => 'Saint Pierre and Miquelon'],
            ['is_enabled' => false, 'code' => 'VC', 'name' => 'Saint Vincent and the Grenadines'],
            ['is_enabled' => false, 'code' => 'WS', 'name' => 'Samoa'],
            ['is_enabled' => false, 'code' => 'SM', 'name' => 'San Marino'],
            ['is_enabled' => false, 'code' => 'ST', 'name' => 'Sao Tome and Principe'],
            ['is_enabled' => false, 'code' => 'SA', 'name' => 'Saudi Arabia'],
            ['is_enabled' => false, 'code' => 'SN', 'name' => 'Senegal'],
            ['is_enabled' => false, 'code' => 'RS', 'name' => 'Serbia'],
            ['is_enabled' => false, 'code' => 'SC', 'name' => 'Seychelles'],
            ['is_enabled' => false, 'code' => 'SL', 'name' => 'Sierra Leone'],
            ['is_enabled' => false, 'code' => 'SG', 'name' => 'Singapore'],
            ['is_enabled' => false, 'code' => 'SX', 'name' => 'Sint Maarten (Dutch part)'],
            ['is_enabled' => false, 'code' => 'SK', 'name' => 'Slovakia'],
            ['is_enabled' => false, 'code' => 'SI', 'name' => 'Slovenia'],
            ['is_enabled' => false, 'code' => 'SB', 'name' => 'Solomon Islands'],
            ['is_enabled' => false, 'code' => 'SO', 'name' => 'Somalia'],
            ['is_enabled' => false, 'code' => 'ZA', 'name' => 'South Africa'],
            ['is_enabled' => false, 'code' => 'GS', 'name' => 'South Georgia and the South Sandwich Islands'],
            ['is_enabled' => false, 'code' => 'LK', 'name' => 'Sri Lanka'],
            ['is_enabled' => false, 'code' => 'SD', 'name' => 'Sudan'],
            ['is_enabled' => false, 'code' => 'SR', 'name' => 'Suriname'],
            ['is_enabled' => false, 'code' => 'SJ', 'name' => 'Svalbard and Jan Mayen'],
            ['is_enabled' => false, 'code' => 'SZ', 'name' => 'Swaziland'],
            ['is_enabled' => false, 'code' => 'SY', 'name' => 'Syrian Arab Republic'],
            ['is_enabled' => false, 'code' => 'TW', 'name' => 'Taiwan, Province of China'],
            ['is_enabled' => false, 'code' => 'TJ', 'name' => 'Tajikistan'],
            ['is_enabled' => false, 'code' => 'TZ', 'name' => 'Tanzania, United Republic of'],
            ['is_enabled' => false, 'code' => 'TH', 'name' => 'Thailand'],
            ['is_enabled' => false, 'code' => 'TL', 'name' => 'Timor-Leste'],
            ['is_enabled' => false, 'code' => 'TG', 'name' => 'Togo'],
            ['is_enabled' => false, 'code' => 'TK', 'name' => 'Tokelau'],
            ['is_enabled' => false, 'code' => 'TO', 'name' => 'Tonga'],
            ['is_enabled' => false, 'code' => 'TT', 'name' => 'Trinidad and Tobago'],
            ['is_enabled' => false, 'code' => 'TN', 'name' => 'Tunisia'],
            ['is_enabled' => false, 'code' => 'TR', 'name' => 'Turkey'],
            ['is_enabled' => false, 'code' => 'TM', 'name' => 'Turkmenistan'],
            ['is_enabled' => false, 'code' => 'TC', 'name' => 'Turks and Caicos Islands'],
            ['is_enabled' => false, 'code' => 'TV', 'name' => 'Tuvalu'],
            ['is_enabled' => false, 'code' => 'UG', 'name' => 'Uganda'],
            ['is_enabled' => false, 'code' => 'UA', 'name' => 'Ukraine'],
            ['is_enabled' => false, 'code' => 'AE', 'name' => 'United Arab Emirates'],
            ['is_enabled' => false, 'code' => 'UM', 'name' => 'United States Minor Outlying Islands'],
            ['is_enabled' => false, 'code' => 'UY', 'name' => 'Uruguay'],
            ['is_enabled' => false, 'code' => 'UZ', 'name' => 'Uzbekistan'],
            ['is_enabled' => false, 'code' => 'VU', 'name' => 'Vanuatu'],
            ['is_enabled' => false, 'code' => 'VE', 'name' => 'Venezuela, Bolivarian Republic of'],
            ['is_enabled' => false, 'code' => 'VN', 'name' => 'Viet Nam'],
            ['is_enabled' => false, 'code' => 'VG', 'name' => 'Virgin Islands, British'],
            ['is_enabled' => false, 'code' => 'VI', 'name' => 'Virgin Islands, U.S.'],
            ['is_enabled' => false, 'code' => 'WF', 'name' => 'Wallis and Futuna'],
            ['is_enabled' => false, 'code' => 'EH', 'name' => 'Western Sahara'],
            ['is_enabled' => false, 'code' => 'YE', 'name' => 'Yemen'],
            ['is_enabled' => false, 'code' => 'ZM', 'name' => 'Zambia'],
            ['is_enabled' => false, 'code' => 'ZW', 'name' => 'Zimbabwe']
        ]);

        $us = Country::whereCode('US')->first();
        $us->states()->createMany([
            ['code' => 'AL', 'name' => 'Alabama'],
            ['code' => 'AK', 'name' => 'Alaska'],
            ['code' => 'AS', 'name' => 'American Samoa'],
            ['code' => 'AZ', 'name' => 'Arizona'],
            ['code' => 'AR', 'name' => 'Arkansas'],
            ['code' => 'CA', 'name' => 'California'],
            ['code' => 'CO', 'name' => 'Colorado'],
            ['code' => 'CT', 'name' => 'Connecticut'],
            ['code' => 'DE', 'name' => 'Delaware'],
            ['code' => 'DC', 'name' => 'Dist. of Columbia'],
            ['code' => 'FL', 'name' => 'Florida'],
            ['code' => 'GA', 'name' => 'Georgia'],
            ['code' => 'GU', 'name' => 'Guam'],
            ['code' => 'HI', 'name' => 'Hawaii'],
            ['code' => 'ID', 'name' => 'Idaho'],
            ['code' => 'IL', 'name' => 'Illinois'],
            ['code' => 'IN', 'name' => 'Indiana'],
            ['code' => 'IA', 'name' => 'Iowa'],
            ['code' => 'KS', 'name' => 'Kansas'],
            ['code' => 'KY', 'name' => 'Kentucky'],
            ['code' => 'LA', 'name' => 'Louisiana'],
            ['code' => 'ME', 'name' => 'Maine'],
            ['code' => 'MD', 'name' => 'Maryland'],
            ['code' => 'MH', 'name' => 'Marshall Islands'],
            ['code' => 'MA', 'name' => 'Massachusetts'],
            ['code' => 'MI', 'name' => 'Michigan'],
            ['code' => 'FM', 'name' => 'Micronesia'],
            ['code' => 'MN', 'name' => 'Minnesota'],
            ['code' => 'MS', 'name' => 'Mississippi'],
            ['code' => 'MO', 'name' => 'Missouri'],
            ['code' => 'MT', 'name' => 'Montana'],
            ['code' => 'NE', 'name' => 'Nebraska'],
            ['code' => 'NV', 'name' => 'Nevada'],
            ['code' => 'NH', 'name' => 'New Hampshire'],
            ['code' => 'NJ', 'name' => 'New Jersey'],
            ['code' => 'NM', 'name' => 'New Mexico'],
            ['code' => 'NY', 'name' => 'New York'],
            ['code' => 'NC', 'name' => 'North Carolina'],
            ['code' => 'ND', 'name' => 'North Dakota'],
            ['code' => 'MP', 'name' => 'Northern Marianas'],
            ['code' => 'OH', 'name' => 'Ohio'],
            ['code' => 'OK', 'name' => 'Oklahoma'],
            ['code' => 'OR', 'name' => 'Oregon'],
            ['code' => 'PW', 'name' => 'Palau'],
            ['code' => 'PA', 'name' => 'Pennsylvania'],
            ['code' => 'PR', 'name' => 'Puerto Rico'],
            ['code' => 'RI', 'name' => 'Rhode Island'],
            ['code' => 'SC', 'name' => 'South Carolina'],
            ['code' => 'SD', 'name' => 'South Dakota'],
            ['code' => 'TN', 'name' => 'Tennessee'],
            ['code' => 'TX', 'name' => 'Texas'],
            ['code' => 'UT', 'name' => 'Utah'],
            ['code' => 'VT', 'name' => 'Vermont'],
            ['code' => 'VA', 'name' => 'Virginia'],
            ['code' => 'VI', 'name' => 'Virgin Islands'],
            ['code' => 'WA', 'name' => 'Washington'],
            ['code' => 'WV', 'name' => 'West Virginia'],
            ['code' => 'WI', 'name' => 'Wisconsin'],
            ['code' => 'WY', 'name' => 'Wyoming']
        ]);

        $ca = Country::whereCode('CA')->first();
        $ca->states()->createMany([
            ['code' => 'AB', 'name' => 'Alberta'],
            ['code' => 'BC', 'name' => 'British Columbia'],
            ['code' => 'MB', 'name' => 'Manitoba'],
            ['code' => 'NB', 'name' => 'New Brunswick'],
            ['code' => 'NL', 'name' => 'Newfoundland and Labrador'],
            ['code' => 'NT', 'name' => 'Northwest Territories'],
            ['code' => 'NS', 'name' => 'Nova Scotia'],
            ['code' => 'NU', 'name' => 'Nunavut'],
            ['code' => 'ON', 'name' => 'Ontario'],
            ['code' => 'PE', 'name' => 'Prince Edward Island'],
            ['code' => 'QC', 'name' => 'Quebec'],
            ['code' => 'SK', 'name' => 'Saskatchewan'],
            ['code' => 'YT', 'name' => 'Yukon']
        ]);

        $au = Country::whereCode('AU')->first();
        $au->states()->createMany([
            ['code' => 'NSW', 'name' => 'New South Wales'],
            ['code' => 'QLD', 'name' => 'Queensland'],
            ['code' => 'SA', 'name' => 'South Australia'],
            ['code' => 'TAS', 'name' => 'Tasmania'],
            ['code' => 'VIC', 'name' => 'Victoria'],
            ['code' => 'WA', 'name' => 'Western Australia'],
            ['code' => 'NT', 'name' => 'Northern Territory'],
            ['code' => 'ACT', 'name' => 'Australian Capital Territory']
        ]);

        $de = Country::whereCode('DE')->first();
        $de->states()->createMany([
            ['code' => 'BW', 'name' => 'Baden-Württemberg'],
            ['code' => 'BY', 'name' => 'Bavaria'],
            ['code' => 'BE', 'name' => 'Berlin'],
            ['code' => 'BB', 'name' => 'Brandenburg'],
            ['code' => 'HB', 'name' => 'Bremen'],
            ['code' => 'HH', 'name' => 'Hamburg'],
            ['code' => 'HE', 'name' => 'Hesse'],
            ['code' => 'MV', 'name' => 'Mecklenburg-Vorpommern'],
            ['code' => 'NI', 'name' => 'Lower Saxony'],
            ['code' => 'NW', 'name' => 'North Rhine-Westphalia'],
            ['code' => 'RP', 'name' => 'Rhineland-Palatinate'],
            ['code' => 'SL', 'name' => 'Saarland'],
            ['code' => 'SN', 'name' => 'Saxony'],
            ['code' => 'ST', 'name' => 'Saxony-Anhalt'],
            ['code' => 'SH', 'name' => 'Schleswig-Holstein'],
            ['code' => 'TH', 'name' => 'Thuringia']
        ]);

        $ie = Country::whereCode('IE')->first();
        $ie->states()->createMany([
            ['code' => 'D', 'name' => 'Dublin'],
            ['code' => 'WW', 'name' => 'Wicklow'],
            ['code' => 'WX', 'name' => 'Wexford'],
            ['code' => 'CW', 'name' => 'Carlow'],
            ['code' => 'KE', 'name' => 'Kildare'],
            ['code' => 'MH', 'name' => 'Meath'],
            ['code' => 'LH', 'name' => 'Louth'],
            ['code' => 'MN', 'name' => 'Monaghan'],
            ['code' => 'CN', 'name' => 'Cavan'],
            ['code' => 'LD', 'name' => 'Longford'],
            ['code' => 'WH', 'name' => 'Westmeath'],
            ['code' => 'OY', 'name' => 'Offaly'],
            ['code' => 'LS', 'name' => 'Laois'],
            ['code' => 'KK', 'name' => 'Kilkenny'],
            ['code' => 'WD', 'name' => 'Waterford'],
            ['code' => 'C', 'name' => 'Cork'],
            ['code' => 'KY', 'name' => 'Kerry'],
            ['code' => 'LK', 'name' => 'Limerick'],
            ['code' => 'TN', 'name' => 'North Tipperary'],
            ['code' => 'TS', 'name' => 'South Tipperary'],
            ['code' => 'CE', 'name' => 'Clare'],
            ['code' => 'G', 'name' => 'Galway'],
            ['code' => 'MO', 'name' => 'Mayo'],
            ['code' => 'RN', 'name' => 'Roscommon'],
            ['code' => 'SO', 'name' => 'Sligo'],
            ['code' => 'LM', 'name' => 'Leitrim'],
            ['code' => 'DL', 'name' => 'Donegal']
        ]);
        
        $nl = Country::whereCode('NL')->first();
        $nl->states()->createMany([
            ['code' => 'DR', 'name' => 'Drenthe'],
            ['code' => 'FL', 'name' => 'Flevoland'],
            ['code' => 'FR', 'name' => 'Friesland'],
            ['code' => 'GE', 'name' => 'Gelderland'],
            ['code' => 'GR', 'name' => 'Groningen'],
            ['code' => 'LI', 'name' => 'Limburg'],
            ['code' => 'NB', 'name' => 'Noord-Brabant'],
            ['code' => 'NH', 'name' => 'Noord-Holland'],
            ['code' => 'OV', 'name' => 'Overijssel'],
            ['code' => 'UT', 'name' => 'Utrecht'],
            ['code' => 'ZE', 'name' => 'Zeeland'],
            ['code' => 'ZH', 'name' => 'Zuid-Holland']
        ]);

        $gb = Country::whereCode('GB')->first();
        $gb->states()->createMany([
            ['code' => 'ABE', 'name' => 'Aberdeenshire'],
            ['code' => 'ALY', 'name' => 'Anglesey'],
            ['code' => 'ANG', 'name' => 'Angus'],
            ['code' => 'ARG', 'name' => 'Argyll'],
            ['code' => 'AYR', 'name' => 'Ayrshire'],
            ['code' => 'BAN', 'name' => 'Banffshire'],
            ['code' => 'BED', 'name' => 'Bedfordshire'],
            ['code' => 'BER', 'name' => 'Berkshire'],
            ['code' => 'BWS', 'name' => 'Berwickshire'],
            ['code' => 'BRE', 'name' => 'Brecknockshire'],
            ['code' => 'BUC', 'name' => 'Buckinghamshire'],
            ['code' => 'BUT', 'name' => 'Bute'],
            ['code' => 'CAE', 'name' => 'Caernarfonshire'],
            ['code' => 'CAI', 'name' => 'Caithness'],
            ['code' => 'CAM', 'name' => 'Cambridgeshire'],
            ['code' => 'CAR', 'name' => 'Cardiganshire'],
            ['code' => 'CMS', 'name' => 'Carmarthenshire'],
            ['code' => 'CHE', 'name' => 'Cheshire'],
            ['code' => 'CLA', 'name' => 'Clackmannanshire'],
            ['code' => 'CLE', 'name' => 'Cleveland'],
            ['code' => 'COR', 'name' => 'Cornwall'],
            ['code' => 'CRO', 'name' => 'Cromartyshire'],
            ['code' => 'CBR', 'name' => 'Cumberland'],
            ['code' => 'CUM', 'name' => 'Cumbria'],
            ['code' => 'DEN', 'name' => 'Denbighshire'],
            ['code' => 'DER', 'name' => 'Derbyshire'],
            ['code' => 'DEV', 'name' => 'Devon'],
            ['code' => 'DOR', 'name' => 'Dorset'],
            ['code' => 'DBS', 'name' => 'Dumbartonshire'],
            ['code' => 'DUM', 'name' => 'Dumfriesshire'],
            ['code' => 'DUR', 'name' => 'Durham'],
            ['code' => 'ELO', 'name' => 'East Lothian'],
            ['code' => 'ESS', 'name' => 'Essex'],
            ['code' => 'FLI', 'name' => 'Flintshire'],
            ['code' => 'FIF', 'name' => 'Fife'],
            ['code' => 'GLA', 'name' => 'Glamorgan'],
            ['code' => 'GLO', 'name' => 'Gloucestershire'],
            ['code' => 'HAM', 'name' => 'Hampshire'],
            ['code' => 'HER', 'name' => 'Herefordshire'],
            ['code' => 'HTF', 'name' => 'Hertfordshire'],
            ['code' => 'HUN', 'name' => 'Huntingdonshire'],
            ['code' => 'INV', 'name' => 'Inverness'],
            ['code' => 'KEN', 'name' => 'Kent'],
            ['code' => 'KCD', 'name' => 'Kincardineshire'],
            ['code' => 'KIN', 'name' => 'Kinross-shire'],
            ['code' => 'KIR', 'name' => 'Kirkcudbrightshire'],
            ['code' => 'LKS', 'name' => 'Lanarkshire'],
            ['code' => 'LAN', 'name' => 'Lancashire'],
            ['code' => 'LEI', 'name' => 'Leicestershire'],
            ['code' => 'LIN', 'name' => 'Lincolnshire'],
            ['code' => 'LON', 'name' => 'London'],
            ['code' => 'MAN', 'name' => 'Manchester'],
            ['code' => 'MER', 'name' => 'Merionethshire'],
            ['code' => 'MER', 'name' => 'Merseyside'],
            ['code' => 'MDX', 'name' => 'Middlesex'],
            ['code' => 'MID', 'name' => 'Midlands'],
            ['code' => 'MLT', 'name' => 'Midlothian'],
            ['code' => 'MON', 'name' => 'Monmouthshire'],
            ['code' => 'MGY', 'name' => 'Montgomeryshire'],
            ['code' => 'MOR', 'name' => 'Moray'],
            ['code' => 'NAI', 'name' => 'Nairnshire'],
            ['code' => 'NOR', 'name' => 'Norfolk'],
            ['code' => 'NMP', 'name' => 'Northamptonshire'],
            ['code' => 'NUM', 'name' => 'Northumberland'],
            ['code' => 'NOT', 'name' => 'Nottinghamshire'],
            ['code' => 'ORK', 'name' => 'Orkney'],
            ['code' => 'OXF', 'name' => 'Oxfordshire'],
            ['code' => 'PEE', 'name' => 'Peebleshire'],
            ['code' => 'PEM', 'name' => 'Pembrokeshire'],
            ['code' => 'PER', 'name' => 'Perthshire'],
            ['code' => 'RAD', 'name' => 'Radnorshire'],
            ['code' => 'REN', 'name' => 'Renfrewshire'],
            ['code' => 'ROS', 'name' => 'Ross & Cromarty'],
            ['code' => 'ROX', 'name' => 'Roxburghshire'],
            ['code' => 'RUT', 'name' => 'Rutland'],
            ['code' => 'SEL', 'name' => 'Selkirkshire'],
            ['code' => 'SHE', 'name' => 'Shetland'],
            ['code' => 'SHR', 'name' => 'Shropshire'],
            ['code' => 'SOM', 'name' => 'Somerset'],
            ['code' => 'STA', 'name' => 'Staffordshire'],
            ['code' => 'STI', 'name' => 'Stirlingshire'],
            ['code' => 'SUF', 'name' => 'Suffolk'],
            ['code' => 'SUR', 'name' => 'Surrey'],
            ['code' => 'SUS', 'name' => 'Sussex'],
            ['code' => 'SUT', 'name' => 'Sutherland'],
            ['code' => 'TYN', 'name' => 'Tyne & Wear'],
            ['code' => 'WAR', 'name' => 'Warwickshire'],
            ['code' => 'WLO', 'name' => 'West Lothian'],
            ['code' => 'WES', 'name' => 'Westmorland'],
            ['code' => 'WIG', 'name' => 'Wigtownshire'],
            ['code' => 'WIL', 'name' => 'Wiltshire'],
            ['code' => 'WOR', 'name' => 'Worcestershire'],
            ['code' => 'YOR', 'name' => 'Yorkshire']
        ]);

        $hu = Country::whereCode('HU')->first();
        $hu->states()->createMany([
            ['code' => 'BUD', 'name' => 'Budapest'],
            ['code' => 'BAR', 'name' => 'Baranya'],
            ['code' => 'BKM', 'name' => 'Bács-Kiskun'],
            ['code' => 'BEK', 'name' => 'Békés'],
            ['code' => 'BAZ', 'name' => 'Borsod-Abaúj-Zemplén'],
            ['code' => 'CSO', 'name' => 'Csongrád'],
            ['code' => 'FEJ', 'name' => 'Fejér'],
            ['code' => 'GMS', 'name' => 'Győr-Moson-Sopron'],
            ['code' => 'HBM', 'name' => 'Hajdú-Bihar'],
            ['code' => 'HEV', 'name' => 'Heves'],
            ['code' => 'JNS', 'name' => 'Jász-Nagykun-Szolnok'],
            ['code' => 'KEM', 'name' => 'Komárom-Esztergom'],
            ['code' => 'NOG', 'name' => 'Nógrád'],
            ['code' => 'PES', 'name' => 'Pest'],
            ['code' => 'SOM', 'name' => 'Somogy'],
            ['code' => 'SSB', 'name' => 'Szabolcs-Szatmár-Bereg'],
            ['code' => 'TOL', 'name' => 'Tolna'],
            ['code' => 'VAS', 'name' => 'Vas'],
            ['code' => 'VES', 'name' => 'Veszprém'],
            ['code' => 'ZAL', 'name' => 'Zala']
        ]);

        $in = Country::whereCode('IN')->first();
        $in->states()->createMany([
            ['code' => 'AP', 'name' => 'Andhra Pradesh'],
            ['code' => 'AR', 'name' => 'Arunachal Pradesh'],
            ['code' => 'AS', 'name' => 'Assam'],
            ['code' => 'BR', 'name' => 'Bihar'],
            ['code' => 'CT', 'name' => 'Chhattisgarh'],
            ['code' => 'GA', 'name' => 'Goa'],
            ['code' => 'GJ', 'name' => 'Gujarat'],
            ['code' => 'HR', 'name' => 'Haryana'],
            ['code' => 'HP', 'name' => 'Himachal Pradesh'],
            ['code' => 'JK', 'name' => 'Jammu and Kashmir'],
            ['code' => 'JH', 'name' => 'Jharkhand'],
            ['code' => 'KA', 'name' => 'Karnataka'],
            ['code' => 'KL', 'name' => 'Kerala'],
            ['code' => 'MP', 'name' => 'Madhya Pradesh'],
            ['code' => 'MH', 'name' => 'Maharashtra'],
            ['code' => 'MN', 'name' => 'Manipur'],
            ['code' => 'ML', 'name' => 'Meghalaya'],
            ['code' => 'MZ', 'name' => 'Mizoram'],
            ['code' => 'NL', 'name' => 'Nagaland'],
            ['code' => 'OR', 'name' => 'Odisha'],
            ['code' => 'PB', 'name' => 'Punjab'],
            ['code' => 'RJ', 'name' => 'Rajasthan'],
            ['code' => 'SK', 'name' => 'Sikkim'],
            ['code' => 'TN', 'name' => 'Tamil Nadu'],
            ['code' => 'TG', 'name' => 'Telangana'],
            ['code' => 'TR', 'name' => 'Tripura'],
            ['code' => 'UT', 'name' => 'Uttarakhand'],
            ['code' => 'UP', 'name' => 'Uttar Pradesh'],
            ['code' => 'WB', 'name' => 'West Bengal'],
            ['code' => 'AN', 'name' => 'Andaman and Nicobar Islands'],
            ['code' => 'CH', 'name' => 'Chandigarh'],
            ['code' => 'DN', 'name' => 'Dadra and Nagar Haveli'],
            ['code' => 'DD', 'name' => 'Daman and Diu'],
            ['code' => 'DL', 'name' => 'Delhi'],
            ['code' => 'LD', 'name' => 'Lakshadweep'],
            ['code' => 'PY', 'name' => 'Puducherry']
        ]);
    }
}
