<?php namespace Illuminate\Mail\Transport;

use Swift_Transport;
use Aws\Ses\SesClient;
use Swift_Mime_Message;
use Swift_Events_EventListener;

class SesTransport implements Swift_Transport {

	/**
	 * The Amazon SES instance.
	 *
	 * @var \Aws\Ses\SesClient
	 */
	protected $ses;

	/**
	 * Create a new SES transport instance.
	 *
	 * @param  \Aws\Ses\SesClient  $ses
	 * @return void
	 */
	public function __construct(SesClient $ses)
	{
		$this->ses = $ses;
	}

	/**
	 * {@inheritdoc}
	 */
	public function isStarted()
	{
		return true;
	}

	/**
	 * {@inheritdoc}
	 */
	public function start()
	{
		return true;
	}

	/**
	 * {@inheritdoc}
	 */
	public function stop()
	{
		return true;
	}

	/**
	 * {@inheritdoc}
	 */
	public function send(Swift_Mime_Message $message, &$failedRecipients = null)
	{
		return $this->ses->sendRawEmail([
			'Source' => $message->getSender(),
			'Destinations' => $this->getTo($message),
			'RawMessage' => [
				'Data' => base64_encode((string) $message),
			],
		]);
	}

	/**
	 * {@inheritdoc}
	 */
	public function registerPlugin(Swift_Events_EventListener $plugin)
	{
		//
	}

	/**
	 * Get the "to" payload field for the API request.
	 *
	 * @param  \Swift_Mime_Message  $message
	 * @return array
	 */
	protected function getTo(Swift_Mime_Message $message)
	{
		$destinations = [];

		$contacts = array_merge(
			(array) $message->getTo(), (array) $message->getCc(), (array) $message->getBcc()
		);

		foreach ($contacts as $address => $display)
		{
			$destinations[] = $address;
		}

		return $destinations;
	}

}
